/*
 * Copyright 2000-2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.tutorial.modules.actions.portlets;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;

// Turbine stuff
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.turbine.services.TurbineServices;

// Velocity Stuff
import org.apache.velocity.context.Context;

// Jetspeed stuff
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction;
import org.apache.jetspeed.util.PortletConfigState;
import org.apache.jetspeed.util.StringUtils;

/**
 * Tutorial 7 - Action Events
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: CobiJonesPortletAction.java,v 1.1 2004/04/08 17:03:54 taylor Exp $
 */
public class CobiJonesPortletAction extends VelocityPortletAction
{

    public static final String INPUT_FIRST_NAME = "firstname";
    public static final String INPUT_LAST_NAME  = "lastname";
    public static final String INPUT_POSITION   = "position";
    public static final String INPUT_CAPS       = "caps";
    public static final String INPUT_ACTIVE     = "active";

    public static final String PLAYER = "player";
    public static final String COBI_ERROR = "cobierror";


    /**
     * Build the normal state content for this portlet.
     *
     * @param portlet The velocity-based portlet that is being built.
     * @param context The velocity context for this request.
     * @param rundata The turbine rundata context for this request.
     */


    protected void buildNormalContext(VelocityPortlet portlet,
                                       Context context,
                                       RunData rundata)
    {
        try
        {
            Player player = (Player)rundata.getUser().getTemp(PLAYER);
            if (null == player)
            {
                player = createNewPlayer();
                rundata.getUser().setTemp(PLAYER, player);
            }
            context.put(PLAYER, player);

            // make sure they don't sub Cobi!
            String cobiError = (String)rundata.getRequest().getAttribute(COBI_ERROR);
            if (null != cobiError)
            {
                context.put(COBI_ERROR, cobiError);
            }
        }
        catch (Exception e)
        {
            Log.error(e);
            context.put(COBI_ERROR, e.toString());
        }
    }


    /**
     * Update the portlet state from the form.
     *
     * @param rundata The turbine rundata context for this request.
     * @param context The velocity context for this request.
     */
    public void doUpdate(RunData rundata, Context context) throws Exception
    {
        Player player = (Player)rundata.getUser().getTemp(PLAYER);
        if (null == player)
        {
            player = createNewPlayer();
            rundata.getUser().setTemp(PLAYER, player);
        }

        String cobi = rundata.getParameters().getString(INPUT_FIRST_NAME);
        String jones = rundata.getParameters().getString(INPUT_LAST_NAME);
        if (!cobi.equalsIgnoreCase("Cobi") || !jones.equalsIgnoreCase("Jones"))
        {
            rundata.getRequest().setAttribute(COBI_ERROR,
                                             "Hey now, you cant substitute Cobi with " 
                                              + cobi + " " + jones + "!");            
        }
        player.setFirstName(cobi);
        player.setLastName(jones);
        player.setPosition(rundata.getParameters().getString(INPUT_POSITION));
        player.setCaps(rundata.getParameters().getInt(INPUT_CAPS));
        player.setActive(rundata.getParameters().getBoolean(INPUT_ACTIVE));

        rundata.getUser().setTemp(PLAYER, player);

    }

    ///////////////////////////////////////////////////////////////////////////

    public Player createNewPlayer()
    {
        return new Player("Cobi", "Jones", "Midfielder", 150, true);

    }

    public class Player
    {
        private String firstName;
        private String lastName;
        private String position;
        private int caps;
        boolean active;

        public Player(String firstName,
                      String lastName,
                      String position,
                      int caps,
                      boolean active)
        {
            this.firstName = firstName;
            this.lastName = lastName;
            this.position = position;
            this.caps = caps;
            this.active = active;
        }


        public String getFirstName()
        {
            return this.firstName;
        }

        public void setFirstName(String firstName)
        {
            this.firstName = firstName;
        }

        public String getLastName()
        {
            return this.lastName;
        }

        public void setLastName(String lastName)
        {
            this.lastName = lastName;
        }

        public String getPosition()
        {
            return this.position;
        }

        public void setPosition(String position)
        {
            this.position = position;
        }

        public int getCaps()
        {
            return this.caps;
        }

        public void setCaps(int caps)
        {
            this.caps = caps;
        }

        public boolean getActive()
         {
             return this.active;
         }

         public void setActive(boolean active)
         {
             this.active = active;
         }
    }
}
