/*
 * Copyright 2000-2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.tutorial.portal.portlets;

import java.util.Date;

import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.AbstractInstancePortlet;

import org.apache.turbine.util.RunData;
import org.apache.jetspeed.services.rundata.JetspeedRunData;

import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.util.MimeType;
import org.apache.jetspeed.portal.PortletConfig;

import org.apache.turbine.om.security.User;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;

/**
 * Introduction to the Portlet interface
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: HelloPortletInterface.java,v 1.1 2004/04/08 17:03:54 taylor Exp $
 */
public class HelloPortletInterface extends AbstractInstancePortlet
{

    public void init() throws PortletException
    {
    }

    public ConcreteElement getContent(RunData rundata)
    {        
        JetspeedRunData jrun = (JetspeedRunData) rundata;
        PortletConfig pc = this.getPortletConfig();

        CapabilityMap map = jrun.getCapability();
        
        StringBuffer text = new StringBuffer();
        
        String mimeType = map.getPreferredType().toString();

        if (this.supportsType(map.getPreferredType()))
        {
            text.append("Supports preferred MimeType: " + mimeType);
        }
        else
        {
            text.append("Doesn't support preferred MimeType: " + mimeType);
        }
        

        // **** getPortletConfig().getInitParameter() example
        //String greeting = getPortletConfig ().getInitParameter ("greeting");
        //text.append(greeting);
        text.append("<BR/>"); // bad bad bad

        String name = rundata.getUser().getFirstName();
        if (name == null)
            name ="Anonymous";
        text.append (name);
        text.append ("!");

        text.append("<BR/>"); // bad bad bad

        text.append("Portlet id = " + this.getID());
        text.append("<BR/>"); // bad bad bad
        text.append("Init Parameter (version): " + pc.getInitParameter("version", "NOT FOUND!"));        
        text.append("<BR/>"); // bad bad bad
        text.append("Page Attribute (city): " + this.getAttribute("city", "NOT FOUND!", rundata));
        text.append("<BR/>"); // bad bad bad

        switch (jrun.getMode())
        {
        case JetspeedRunData.NORMAL:
            text.append("MODE = VIEW");
            break;
        case JetspeedRunData.CUSTOMIZE:
            text.append("MODE = CUSTOMIZE");
            break;
        case JetspeedRunData.MAXIMIZE:
            text.append("MODE = MINIMIZE");
            break;
        default:
            text.append("MODE = UNKNOWN");
            break;
        }

        return (new StringElement(text.toString()));
    }

/***
    For Tutorial section 6.2 on Portlet Life Cycle
    
    public static Object getHandle(Object config)
    {
        PortletConfig pc = null;

        if (!(config instanceof PortletConfig))
        {
            return null;            
        }
        return pc.getName();
    }   
***/

}

