/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.modules.actions.whereaboutsinformation;

import java.util.ArrayList;
import java.util.List;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whereaboutsinformation.WhereaboutsInformationSelectData;

/**
 * 在席管理に関するアクションクラスです。 <br />
 * 
 */
public class WhereaboutsInformationAction extends ALBaseAction {
  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(WhereaboutsInformationAction.class.getName());

  /**
   * @see org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction#buildNormalContext(org.apache.jetspeed.portal.portlets.VelocityPortlet,
   *      org.apache.velocity.context.Context, org.apache.turbine.util.RunData)
   */
  protected void buildNormalContext(VelocityPortlet portlet, Context context,
      RunData rundata) throws Exception {

    // セッション情報をクリアする。
    clearWhereaboutsinformationSession(rundata, context);

    WhereaboutsInformationSelectData listData = new WhereaboutsInformationSelectData();

    // PSMLからパラメータをロードする
    // 最大表示件数（通常時）
    listData.setRowsNum(Integer.parseInt(portlet.getPortletConfig()
        .getInitParameter("p1a-rows")));
    listData.doViewList(this, rundata, context);// DBからのオブジェクトをコンテキストに入れるだけの処理
    setTemplate(rundata, "whereaboutsinformation");// 使用するテンプレートを指定
  }

  /**
   * 最大化表示の際の処理を記述します。 <BR>
   * 
   * @param portlet
   * @param context
   * @param rundata
   */
  protected void buildMaximizedContext(VelocityPortlet portlet,
      Context context, RunData rundata) {
    try {
      doWhereaboutsinformation_list(rundata, context);
    } catch (Exception ex) {
      logger.error("Exception", ex);
    }

  }

  /**
   * 在席情報のリストを表示する <BR>
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doWhereaboutsinformation_list(RunData rundata, Context context)
      throws Exception {

    WhereaboutsInformationSelectData listData = new WhereaboutsInformationSelectData();

    // PSMLからパラメータをロードする
    // 最大表示件数（通常時）
    listData.setRowsNum(Integer.parseInt(ALEipUtils
        .getPortlet(rundata, context).getPortletConfig().getInitParameter(
            "p1a-rows")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "whereaboutsinformation-list");
  }

  /**
   * 在席情報で使用したセッション情報を消去する．
   * 
   */
  public void clearWhereaboutsinformationSession(RunData rundata,
      Context context) {
    List list = new ArrayList();
    list.add("entityid");
    list
        .add("com.aimluck.eip.whereaboutsinformation.WhereaboutsInformationSelectDatafilter");
    list
        .add("com.aimluck.eip.whereaboutsinformation.WhereaboutsInformationSelectDatafiltertype");
    ALEipUtils.removeTemp(rundata, context, list);
  }

}
