/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.component.VTimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeZoneRegistryImpl
implements TimeZoneRegistry {
    private static final String DEFAULT_RESOURCE_PREFIX = "/zoneinfo/";
    private Log log = LogFactory.getLog((Class)TimeZoneRegistryImpl.class);
    private static final Map DEFAULT_TIMEZONES = new HashMap();
    private Map timezones;
    private String resourcePrefix;

    public TimeZoneRegistryImpl() {
        this(DEFAULT_RESOURCE_PREFIX);
    }

    public TimeZoneRegistryImpl(String resourcePrefix) {
        this.resourcePrefix = resourcePrefix;
        this.timezones = new HashMap();
    }

    public final void register(TimeZone timezone) {
        this.timezones.put(timezone.getID(), timezone);
    }

    public final void clear() {
        this.timezones.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TimeZone getTimeZone(String id) {
        TimeZone timezone = (TimeZone)this.timezones.get(id);
        if (timezone == null && (timezone = (TimeZone)DEFAULT_TIMEZONES.get(id)) == null) {
            Map map = DEFAULT_TIMEZONES;
            synchronized (map) {
                try {
                    VTimeZone vTimeZone = this.loadVTimeZone(id);
                    if (vTimeZone != null) {
                        timezone = new TimeZone(vTimeZone);
                        DEFAULT_TIMEZONES.put(timezone.getID(), timezone);
                    }
                }
                catch (Exception e) {
                    this.log.warn((Object)"Error occurred loading VTimeZone", (Throwable)e);
                }
            }
        }
        return timezone;
    }

    private VTimeZone loadVTimeZone(String id) throws IOException, ParserException {
        URL resource = TimeZoneRegistryImpl.class.getResource(this.resourcePrefix + id + ".ics");
        if (resource != null) {
            CalendarBuilder builder = new CalendarBuilder();
            Calendar calendar = builder.build(resource.openStream());
            return (VTimeZone)calendar.getComponent("VTIMEZONE");
        }
        return null;
    }
}

