-----------------------------------------------------------------------------
-- Copyright 2004 The Apache Software Foundation
-- 
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
-- 
-- http://www.apache.org/licenses/LICENSE-2.0
-- 
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
-----------------------------------------------------------------------------
    
-----------------------------------------------------------------------------
-- TURBINE_PERMISSION
-----------------------------------------------------------------------------
drop table TURBINE_PERMISSION;
drop sequence TURBINE_PERMI_PERMISSION_ID_SEQ;

CREATE TABLE TURBINE_PERMISSION
(
    PERMISSION_ID serial,
    PERMISSION_NAME varchar (99) NOT NULL,
    OBJECTDATA oid,
    PRIMARY KEY(PERMISSION_ID),
    UNIQUE (PERMISSION_NAME)
);

    
-----------------------------------------------------------------------------
-- TURBINE_ROLE
-----------------------------------------------------------------------------
drop table TURBINE_ROLE;
drop sequence TURBINE_ROLE_ROLE_ID_SEQ;

CREATE TABLE TURBINE_ROLE
(
    ROLE_ID serial,
    ROLE_NAME varchar (99) NOT NULL,
    OBJECTDATA oid,
    PRIMARY KEY(ROLE_ID),
    UNIQUE (ROLE_NAME)
);

    
-----------------------------------------------------------------------------
-- TURBINE_GROUP
-----------------------------------------------------------------------------
drop table TURBINE_GROUP;
drop sequence TURBINE_GROUP_GROUP_ID_SEQ;

CREATE TABLE TURBINE_GROUP
(
    GROUP_ID serial,
    GROUP_NAME varchar (99) NOT NULL,
    OBJECTDATA oid,
    PRIMARY KEY(GROUP_ID),
    UNIQUE (GROUP_NAME)
);

    
-----------------------------------------------------------------------------
-- TURBINE_ROLE_PERMISSION
-----------------------------------------------------------------------------
drop table TURBINE_ROLE_PERMISSION;

CREATE TABLE TURBINE_ROLE_PERMISSION
(
    ROLE_ID integer NOT NULL,
    PERMISSION_ID integer NOT NULL,
    PRIMARY KEY(ROLE_ID,PERMISSION_ID),
    FOREIGN KEY (ROLE_ID) REFERENCES TURBINE_ROLE (ROLE_ID),
    FOREIGN KEY (PERMISSION_ID) REFERENCES TURBINE_PERMISSION (PERMISSION_ID)
);
create  INDEX ROLE_PERMISSION_INDEX ON TURBINE_ROLE_PERMISSION (ROLE_ID, PERMISSION_ID);

    
-----------------------------------------------------------------------------
-- TURBINE_USER
-----------------------------------------------------------------------------
drop table TURBINE_USER;

CREATE TABLE TURBINE_USER
(
    USER_ID integer NOT NULL,
    LOGIN_NAME varchar (32) NOT NULL,
    PASSWORD_VALUE varchar (32) NOT NULL,
    FIRST_NAME varchar (99) NOT NULL,
    LAST_NAME varchar (99) NOT NULL,
    EMAIL varchar (99),
    CONFIRM_VALUE varchar (99),
    MODIFIED timestamp,
    CREATED timestamp,
    LAST_LOGIN timestamp,
    DISABLED VARCHAR(1),
    OBJECTDATA oid,
    PRIMARY KEY(USER_ID),
    UNIQUE (LOGIN_NAME)
);

   
-----------------------------------------------------------------------------
-- TURBINE_USER_GROUP_ROLE
-----------------------------------------------------------------------------
drop table TURBINE_USER_GROUP_ROLE;

CREATE TABLE TURBINE_USER_GROUP_ROLE
(
    USER_ID integer NOT NULL,
    GROUP_ID integer NOT NULL,
    ROLE_ID integer NOT NULL,
    PRIMARY KEY(USER_ID,GROUP_ID,ROLE_ID),
    FOREIGN KEY (USER_ID) REFERENCES TURBINE_USER (USER_ID),
    FOREIGN KEY (GROUP_ID) REFERENCES TURBINE_GROUP (GROUP_ID),
    FOREIGN KEY (ROLE_ID) REFERENCES TURBINE_ROLE (ROLE_ID)
);
create  INDEX USER_GROUP_ROLE_INDEX ON TURBINE_USER_GROUP_ROLE (USER_ID, GROUP_ID, ROLE_ID);

    
-----------------------------------------------------------------------------
-- TURBINE_SCHEDULED_JOB
-----------------------------------------------------------------------------
drop table TURBINE_SCHEDULED_JOB;

CREATE TABLE TURBINE_SCHEDULED_JOB
(
    JOB_ID integer NOT NULL,
    SECOND integer default -1 NOT NULL, 
    MINUTE integer default -1 NOT NULL,
    HOUR integer default -1 NOT NULL,
    WEEK_DAY integer default -1 NOT NULL,
    DAY_OF_MONTH integer default -1 NOT NULL,
    TASK varchar (99) NOT NULL,
    EMAIL varchar (99),
    PROPERTY oid,
    PRIMARY KEY(JOB_ID)
);

-----------------------------------------------------------------------------
-- ID_TABLE
-----------------------------------------------------------------------------

drop table ID_TABLE;

CREATE TABLE ID_TABLE
(
    ID_TABLE_ID integer NOT NULL,
    TABLE_NAME varchar (255) NOT NULL,
    NEXT_ID integer,
    QUANTITY integer,
    PRIMARY KEY (ID_TABLE_ID),
    UNIQUE (TABLE_NAME)
);

-----------------------------------------------------------------------------
-- COFFEES
-----------------------------------------------------------------------------
DROP TABLE COFFEES;
DROP SEQUENCE COFFEES_SEQ;

CREATE SEQUENCE COFFEES_SEQ;

CREATE TABLE COFFEES
(
    COFFEE_ID serial,
    COFFEE_NAME varchar (50),
    SUPPLIER_ID integer,
    PRICE float,
    SALES integer,
    TOTAL integer,
    PRIMARY KEY (COFFEE_ID)
);

-----------------------------------------------------------------------------
-- EMAIL
-----------------------------------------------------------------------------
DROP TABLE EMAIL_INBOX;
DROP SEQUENCE EMAIL_INBOX_SEQ;

CREATE TABLE EMAIL_INBOX (
  EMAIL_INBOX_ID integer(11) NOT NULL auto_increment,
  MESSAGE_ID varchar(255) default NULL,
  FILENAME varchar(255) default NULL,
  ATTACHMENT BYTEA,
  READFLAG int(11) default NULL,
  PRIMARY KEY  (EMAIL_INBOX_ID)
);


