/*
 * Copyright 2000-2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jetspeed.services.psmlmanager;

// Junit imports
import junit.framework.Test;
import junit.framework.TestSuite;


import org.apache.turbine.util.TurbineConfig;
import org.apache.turbine.util.StringUtils;

// Jetspeed imports
import org.apache.jetspeed.test.JetspeedTestCase;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.profile.BaseProfile;

import org.apache.torque.util.Criteria;

/**
 * TestDbCriteria
 *
 * @author <a href="taylor@apache.org">David Sean Taylor</a>
 * @version $Id: TestDbCriteria.java,v 1.1 2004/04/07 22:02:42 jford Exp $
 */

public class TestDbCriteria extends JetspeedTestCase {    


    /** the column name for the PSML_ID field */
    public static final String PSML_ID;
    /** the column name for the USER_NAME field */
    public static final String USER_NAME;
    /** the column name for the MEDIA_TYPE field */
    public static final String MEDIA_TYPE;
    /** the column name for the LANGUAGE field */
    public static final String LANGUAGE;
    /** the column name for the COUNTRY field */
    public static final String COUNTRY;
    /** the column name for the PAGE field */
    public static final String PAGE;
    /** the column name for the PROFILE field */
    public static final String PROFILE;

    static
    {
    PSML_ID = "JETSPEED_USER_PROFILE.PSML_ID";
    USER_NAME = "JETSPEED_USER_PROFILE.USER_NAME";
    MEDIA_TYPE = "JETSPEED_USER_PROFILE.MEDIA_TYPE";
    LANGUAGE = "JETSPEED_USER_PROFILE.LANGUAGE";
    COUNTRY = "JETSPEED_USER_PROFILE.COUNTRY";
    PAGE = "JETSPEED_USER_PROFILE.PAGE";
    PROFILE = "JETSPEED_USER_PROFILE.PROFILE";
    }

    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestDbCriteria( String name ) {
        super( name );
    }
    
    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[]) {
        junit.awtui.TestRunner.main( new String[] { TestDbCriteria.class.getName() } );
    }
 
    /**
     * Creates the test suite.
     *
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite() {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite( TestDbCriteria.class );
    }


    /**
     * Tests generating an SQL string from a profile locator
     * @throws Exception
     */

    public void testLocatorCriteria() throws Exception 
    {

        ProfileLocator locator = new BaseProfile();
        locator.setMediaType("html");
        locator.setLanguage("en");
        locator.setName("default.psml");
            
        Criteria criteria = new Criteria();

        String mediaType = locator.getMediaType();
        String language = locator.getLanguage();
        String country = locator.getCountry();
        String pageName = locator.getName();
        String userName = "anon";

        assertTrue(country == null);

        if (userName != null && userName.length() > 0)
        {
            criteria.add(USER_NAME, userName) ;
        }

        if (pageName != null && pageName.length() > 0)
        {
            criteria.add(PAGE, pageName);
        }

        if (mediaType != null && mediaType.length() > 0)
        {
            criteria.add(MEDIA_TYPE, mediaType);
        }

        if (language != null && language.length() > 0)
        {
             criteria.add(LANGUAGE, language);
        }

        criteria.add(COUNTRY, country);

        String sql = criteria.toString();
        System.out.println("criteria = [" + criteria.toString() + "]");
        assertTrue(sql.indexOf("JETSPEED_USER_PROFILE.COUNTRY IS NULL") > -1);
    }

/*
    Configuration object to run Turbine outside a servlet container
    ( uses turbine.properties )
    */
    private static TurbineConfig config = null;
    
    /**
    Sets up TurbineConfig using the system property:
    <pre>turbine.properties</pre>
    */
    static
    {
        try
        {
            config = new TurbineConfig( "webapp", "/WEB-INF/conf/TurbineResources.properties");
            config.init();
        }
        catch (Exception e)
        {
            fail(StringUtils.stackTrace(e));
        }
    }

}
