/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.intramail;

import java.util.ArrayList;
import java.util.List;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.cayenne.om.portlet.AvzTIntramail;
import com.aimluck.eip.cayenne.om.portlet.AvzTIntramailMap;
import com.aimluck.eip.cayenne.om.portlet.auto._AvzTIntramail;
import com.aimluck.eip.cayenne.om.portlet.auto._AvzTIntramailMap;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.intramail.util.IntraMailUtils;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;

/**
 * IntraMailの複数削除を行うためのクラスです。 <BR>
 * 
 */
public class IntraMailMultiDelete extends ALAbstractCheckList {

	/** logger */
	private static final JetspeedLogger logger = JetspeedLogFactoryService
			.getLogger(IntraMailMultiDelete.class.getName());

	/**
	 * 
	 * @param rundata
	 * @param context
	 * @param values
	 * @param msgList
	 * @return
	 * @see com.aimluck.eip.common.ALAbstractCheckList#action(org.apache.turbine.util.RunData,
	 *      org.apache.velocity.context.Context, java.util.ArrayList,
	 *      java.util.ArrayList)
	 */
	@Override
	protected boolean action(RunData rundata, Context context, ArrayList values,
			ArrayList msgList) {
		
		DataContext dataContext = DatabaseOrmService.getInstance()
		.getDataContext();

		try {
			String s = rundata.getParameters().getString("draft_edit");
			if (s != null && IntraMailUtils.DRAFT_EDIT_FORM.equals(s)) {
				
				//下書きの複数削除
				
				int login_user_id = ALEipUtils.getUserId(rundata);

				String org_id = DatabaseOrmService.getInstance().getOrgId(rundata);

				SelectQuery mail_query = new SelectQuery(AvzTIntramail.class);
				Expression exp1 = ExpressionFactory.matchExp(
						_AvzTIntramail.OWNER_ID_PROPERTY, Integer.valueOf(ALEipUtils
								.getUserId(rundata)));
				mail_query.setQualifier(exp1);
				Expression exp2 = ExpressionFactory.inDbExp(
						_AvzTIntramail.INTRAMAIL_ID_PK_COLUMN, values);
				mail_query.andQualifier(exp2);

				List<AvzTIntramail> list = dataContext.performQuery(mail_query);
				if (list == null || list.size() == 0)
					return false;

				int listsize = list.size();
				for (AvzTIntramail m : list) {
					IntraMailUtils.deleteAvzTIntramail(rundata, context, m);
				}
			} else {
				
		    //受信／送信メールの複数削除
				
				SelectQuery query = new SelectQuery(AvzTIntramailMap.class);
				Expression exp1 = ExpressionFactory.matchExp(
						_AvzTIntramailMap.USER_ID_PROPERTY, Integer.valueOf(ALEipUtils
								.getUserId(rundata)));
				query.setQualifier(exp1);
				Expression exp2 = ExpressionFactory.inDbExp(
						_AvzTIntramailMap.ID_PK_COLUMN, values);
				query.andQualifier(exp2);

				List list = dataContext.performQuery(query);
				if (list == null || list.size() == 0)
					return false;

				int listsize = list.size();
				for (int i = 0; i < listsize; i++) {
					AvzTIntramailMap map = (AvzTIntramailMap) list.get(i);
					/*
					map.setDisabled(IntraMailUtils.DISABLED);
					*/
					
	        if( IntraMailUtils.isLastRecord(map) ) {
	        	//最後のAvzTIntramailMapの場合は、親レコード（AvzTIntramail）
	        	//共々物理削除
	        	IntraMailUtils.deleteAvzTIntramail(rundata, context, map.getToAvzTIntramail());
	        } else { 
	        	//最後でないなら論理削除
	        	map.setDisabled(IntraMailUtils.DISABLED);
	        }
	        
				}
			}

			dataContext.commitChanges();

		} catch (Exception ex) {
			dataContext.rollbackChanges();
			logger.error("Exception", ex);
			return false;
		}
		return true;
	}
}
