/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

dojo.provide("aipo.intramail");

dojo.require("aipo.widget.DropdownDatepicker");
dojo.require("aipo.widget.MemberNormalSelectList");
dojo.require("aipo.intramail.utils");

aipo.intramail.onLoadIntraMailDialog = function(portlet_id){

  var obj = dojo.byId("name");
  if(obj){
     obj.focus();
  }
  
  var closeBtnCker = dojo.byId("dialogCloseButton");
  var handle
  if(closeBtnCker){
    handle = dojo.connect(closeBtnCker, "onclick", this , function() {
      aipo.intramail.utils.onModalDialogWide(false);
    });
  }else{
    if(handle){
      dojo.disconnect(handle);
    }
  }
  aipo.intramail.utils.onModalDialogWide(true);
  
  var mpicker = dijit.byId("membernormalselect");
  if(mpicker){
    var select = dojo.byId('init_memberlist');
    var i;
    var s_o = select.options;
    if (s_o.length == 1 && s_o[0].value == "") return;
    for(i = 0 ; i < s_o.length; i ++ ) {
        mpicker.addOptionSync(s_o[i].value,s_o[i].text,true);
    }
  } 
}

aipo.intramail.onLoadIntraMailDetailDialog = function(portlet_id){
  var closeBtnCker = dojo.byId("dialogCloseButton");
  var handle
  if(closeBtnCker){
    handle = dojo.connect(closeBtnCker, "onclick", this , function() {
      aipo.intramail.utils.onModalDialogWide(false);
    });
  }else{
    if(handle){
      dojo.disconnect(handle);
    }
  }
  aipo.intramail.utils.onModalDialogWide(true);
  
  aipo.portletReload('whatsnew');
}

aipo.intramail.onReceiveMessage = function(msg){

    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(arrDialog){
            arrDialog.hide();
        }
        aipo.portletReload('intramail');
    }
    if (dojo.byId('messageDiv')) {
        dojo.byId('messageDiv').innerHTML = msg;
    }
    
}

aipo.intramail.onListReceiveMessage = function(msg){
  
    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(arrDialog){
            arrDialog.hide();
        }
        aipo.portletReload('intramail');
    }
    if (dojo.byId('listmessageDiv')) {
        dojo.byId('listmessageDiv').innerHTML = msg;
    }
    
}

aipo.intramail.submitStop = function(e){
  if (!e) var e = window.event;
  if(e.keyCode == 13)
    return false;
}

aipo.intramail.addHiddenValue = function(form, name, value){
    if (form[name] && document.getElementsByName(name).item(0)) {
        form[name].value = value;
    } else {
        var q = document.createElement('input');
        q.type = 'hidden';
        q.name = name;
        q.value = value;
        form.appendChild(q);
    }
}

aipo.intramail.hideDialog = function() {

    var arrDialog = dijit.byId("modalDialog");
    if(arrDialog){
       aipo.intramail.utils.onModalDialogWide(false);
       arrDialog.hide();
    }
    aipo.portletReload('intramail');
}

aipo.intramail.openPrint = function(url){
    var wx = 840;
    var wy = 700;
    var x = (screen.width  - wx) / 2;
    var y = (screen.height - wy) / 2;

    var attachment_subwin = window.open(url,"print_window","left="+x+",top="+y+",width="+wx+",height="+wy+",resizable=yes,status=yes,menubar=yes,toolbar=yes,scrollbars=yes");
    attachment_subwin.focus();
}
