/*
 * Copyright 2000-2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jetspeed.modules.actions;

import junit.framework.*;
import org.apache.cactus.*;

import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.RunDataFactory;

/**
 * Tests JLoginUser.
 *
 * @author <a href="mailto:johnny.cass@epiuse.com">Johnny Cass</a>
 * @see JLoginUser
 */
public class TestJLoginUser extends ServletTestCase 
{
    
    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestJLoginUser ( String name ) 
    {
        super( name );
    }
    
    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main ( String[] args ) 
    {
        junit.textui.TestRunner.main ( new String[] { TestJLoginUser.class.getName () } );
    }
    
    /**
     * Creates the test suite.
     *
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite () 
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite ( TestJLoginUser.class );
    }
    
    /**
     * Sets up the test case.
     *
     */
    protected void setUp () throws Exception 
    {
        // Create the RunData object to be used during testing.        
        runData = RunDataFactory.getRunData ( request, response, config );
    }
    
    /**
     * Tests if an invalid user is logged in correctly.
     *
     */
    public void testLoginInvalidUser () throws Exception 
    {        
        // Shouldn't have a user object available at this stage.
        assertNull ( "User should be 'null' since we have not logged in " +
        "yet - runData.getUser () ", runData.getUser () );
        
        // Add parameters to the RunData that will be used to login a non existent user.
        runData.getParameters ().setString ( "username", "" );
        runData.getParameters ().setString ( "password", "" );
        
        // Execute the login action.
        ActionLoader.getInstance ().exec ( runData, "JLoginUser" );
        
        // See if we can find a user object.
        assertNotNull ( "User object not found in RunData - runData.getUser () ",
        runData.getUser () );
        
        // Since the user does not exist, the login should have failed.
        assertEquals ( "Logged in - runData.getUser ().hasLoggedIn ()",
        false, runData.getUser ().hasLoggedIn () );                        
    }
    
    /**
     * Tests if a valid user is logged in correctly.
     *
     */
    public void testLoginValidUser () throws Exception 
    {        
        // Shouldn't have a user object available at this stage.
        assertNull ( "User should be 'null' since we have not logged in " +
        "yet - runData.getUser () ", runData.getUser () );
        
        // Add parameters to the RunData that will be used to login a valid user.
        runData.getParameters ().setString ( "username", "turbine" );
        runData.getParameters ().setString ( "password", "turbine" );
        
        // Execute the login action.
        ActionLoader.getInstance ().exec ( runData, "JLoginUser" );
        
        // See if we can find a user object.
        assertNotNull ( "User object not found in RunData - runData.getUser () ",
        runData.getUser () );
        
        // Since we know the user exists, the login should have been successful/
        assertEquals ( "Not logged in - runData.getUser ().hasLoggedIn ()",
        true, runData.getUser ().hasLoggedIn () );                
    }
    
    private RunData runData = null;
}
