/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.modules.actions.whereaboutsboard;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whereaboutsboard.WhereaboutsboardGroupSelectData;

/**
 * 行先板に関するアクションクラスです。 <br />
 */
public class WhereaboutsboardGroupAction extends ALBaseAction {
  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(WhereaboutsboardGroupAction.class.getName());

  /**
   * @see org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction#buildNormalContext(org.apache.jetspeed.portal.portlets.VelocityPortlet,
   *      org.apache.velocity.context.Context, org.apache.turbine.util.RunData)
   */
  protected void buildNormalContext(VelocityPortlet portlet, Context context,
      RunData rundata) throws Exception {
    WhereaboutsboardGroupSelectData listData = new WhereaboutsboardGroupSelectData();
  
    // PSMLからパラメータをロードする
    // 最大表示件数（通常時）
    listData.setRowsNum(Integer.parseInt(portlet.getPortletConfig()
        .getInitParameter("p1a-rows")));
    listData.doViewList(this, rundata, context);// DBからのオブジェクトをコンテキストに入れるだけの処理
    setTemplate(rundata, "whereaboutsboardgroup");// 使用するテンプレートを指定
  }
  
  /**
   * 最大化表示の際の処理を記述します。 <BR>
   * 
   * @param portlet
   * @param context
   * @param rundata
   */
  protected void buildMaximizedContext(VelocityPortlet portlet,
      Context context, RunData rundata) {
    try {
      doWhereaboutsboardgroup_list(rundata, context);
    } catch (Exception ex) {
      logger.error("Exception", ex);
    }

  }
  
  /**
   * ToDoを削除します。（複数） <BR>
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doWhereaboutsboardgroup_list(RunData rundata, Context context)
      throws Exception {
    WhereaboutsboardGroupSelectData listData = new WhereaboutsboardGroupSelectData();
    
    // PSMLからパラメータをロードする
    // 最大表示件数（通常時）
    listData.setRowsNum(Integer.parseInt(ALEipUtils
        .getPortlet(rundata, context).getPortletConfig().getInitParameter(
            "p1a-rows")));
    listData.doViewList(this, rundata, context);// DBからのオブジェクトをコンテキストに入れるだけの処理
    setTemplate(rundata, "whereaboutsboardgroup-list");// 使用するテンプレートを指定
  }

}
