/*
 * Copyright 2000-2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jetspeed.modules.actions.portlets;

import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/**
 * A secured version of the GenericMVCAction.
 * 
 * @author <a href="mailto:morciuch@apache.org">Mark Orciuch</a>
 *
 * @version $Id: SecureGenericMVCAction.java,v 1.1 2004/03/31 04:47:14 morciuch Exp $
 */
public abstract class SecureGenericMVCAction extends GenericMVCAction
{
    /**
     * This method should be called to execute the event based system.
     *
     * @param data A Turbine RunData object.
     * @param context context information.
     * @exception Exception, a generic exception.
     */
    public void executeEvents(RunData data, Context context) throws Exception
    {
		checkAdministrativeAction(data);
		
        super.executeEvents(data, context);
    }
}
