/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.circulation;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.AvzTCirculationRequest;
import com.aimluck.eip.cayenne.om.portlet.AvzTCirculationRequestMap;
import com.aimluck.eip.circulation.util.CirculationUtils;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;

/**
 * 回覧板の確認フォームデータを管理するクラスです。 <BR>
 * 
 */
public class CirculationConfirmFormData extends ALAbstractFormData {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(CirculationConfirmFormData.class
      .getName());

  /** コメント */
  private ALStringField comment;

  /**
   * 
   * @param action
   * @param rundata
   * @param context
   * @see com.aimluck.eip.common.ALAbstractFormData#init(com.aimluck.eip.modules.actions.common.ALAction,
   *      org.apache.turbine.util.RunData, org.apache.velocity.context.Context)
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    super.init(action, rundata, context);
  }

  /**
   * 各フィールドを初期化します。 <BR>
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
    // コメント
    comment = new ALStringField();
    comment.setTrim(true);
  }

  /**
   * リクエストの各フィールドに対する制約条件を設定します。 <BR>
   * 
   * @see com.aimluck.eip.common.ALAbstractFormData#setValidator()
   */
  @Override
  protected void setValidator() {
    // コメントの文字数制限
    comment.limitMaxLength(1000);
  }

  /**
   * リクエストのフォームに入力されたデータの妥当性検証を行います。 <BR>
   * 
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   * @see com.aimluck.eip.common.ALAbstractFormData#validate(java.util.ArrayList)
   */
  @Override
  protected boolean validate(List<String> msgList) {
    // コメント
    comment.validate(msgList);

    return (msgList.size() == 0);
  }

  /**
   * データベースに格納されているリクエストを更新します。 <BR>
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   * @see com.aimluck.eip.common.ALAbstractFormData#updateFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  @Override
  protected boolean updateFormData(RunData rundata, Context context,
      List<String> msgList) {
    try {
      // オブジェクトモデルを取得
      AvzTCirculationRequest request =
        CirculationUtils.getAvzTCirculationRequest(rundata, context);
      if (request == null) {
        return false;
      }

      List maps =
        CirculationUtils
          .getAvzTCirculationRequestMap(rundata, context, request);
      if (maps == null) {
        throw new Exception("[updateFormData] Not found ID...");
      }
      AvzTCirculationRequestMap map = (AvzTCirculationRequestMap) maps.get(0);

      Date now = Calendar.getInstance().getTime();
      // 現在の申請者は承認
      map.setStatus(CirculationUtils.DB_STATUS_CONFIRM);
      // コメント追記
      map.setNote(comment.getValue());
      map.setUpdateDate(now);

      int c =
        CirculationUtils.getCountOfConfirmedAvzTCirculationRequestMap(request);
      int t = CirculationUtils.getCountOfAvzTCirculationRequestMap(request);

      if (t - c == 1) {
        // 自分が最後の確認者ならば、状態を完了にします。
        request.setProgress(CirculationUtils.DB_PROGRESS_CONFIRM);
        request.setUpdateDate(new Date());
      }

      // リクエストを更新
      Database.commit();
    } catch (Exception ex) {
      logger.error("Exception", ex);
      Database.rollback();
      return false;
    }
    return true;
  }

  @Override
  protected boolean loadFormData(RunData rundata, Context context,
      List<String> msgList) {
    return false;
  }

  @Override
  protected boolean deleteFormData(RunData rundata, Context context,
      List<String> msgList) {
    return false;
  }

  @Override
  protected boolean insertFormData(RunData rundata, Context context,
      List<String> msgList) {
    return false;
  }

  @Override
  public String getAclPortletFeature() {
    return null;
  }

}
