/* $Id: cxp-handler.h,v 1.4 2005/04/17 18:03:18 yasumichi Exp $ */
/**
 * \if japanese
 * @file
 * @brief եμȥץꥱδϢդ
 *
 * եγĥҤ˱ƥե򳫤ץꥱꤹ롣
 * @author 
 * @date Tue Mar 29 2005
 * $Revision: 1.4 $
 * \endif
 * \if english
 * @file
 * @brief Relation of file type and application
 *
 * The application that opens the file according to the extension of the file
 * is decided.
 * @author Yasumichi Akahoshi
 * @date Tue Mar 29 2005
 * $Revision: 1.4 $
 * \endif
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _CXP_HANDLER_H
#define _CXP_HANDLER_H

#ifdef __cplusplus
extern "C"
{
#endif

#include <glib.h>
#include <glib-object.h>

/**
 * \if japanese
 * @brief CxpHandlerΥˡʼ̻Ҥ롣
 *
 * \endif
 * \if english
 * @brief A unique identifier of the CxpHandler type is obtained. 
 *
 * \endif
 */
#define CXP_TYPE_HANDLER				(cxp_handler_get_type ())

/**
 * \if japanese
 * @brief objCxpHandler˥㥹Ȥ롣
 *
 * \endif
 * \if english
 * @brief It is Cast in the CxpHandler type as for obj. 
 *
 * \endif
 */
#define CXP_HANDLER(obj)				(G_TYPE_CHECK_INSTANCE_CAST ((obj), CXP_TYPE_HANDLER, CxpHandler))

/**
 * \if japanese
 * @brief vtableCxpHandlerClass˥㥹Ȥ롣
 *
 * \endif
 * \if english
 * @brief It is Cast in the CxpHandlerClass type as for vtable. 
 *
 * \endif
 */
#define CXP_HANDLER_CLASS(vtable)		(G_TYPE_CHECK_CLASS_CAST ((vtable), CXP_TYPE_HANDLER, CxpHandlerClass))

/**
 * \if japanese
 * @brief objCxpHandlerǤ뤫ǧ롣
 *
 * \endif
 * \if english
 * @brief Whether obj is CxpHandler type is confirmed. 
 *
 * \endif
 */
#define CXP_IS_HANDLER(obj)				(G_TYPE_CHECK_INSTANCE_TYPE ((obj), CXP_TYPE_HANDLER))

/**
 * \if japanese
 * @brief vtableCxpHandlerClassǤ뤫ǧ롣
 *
 * \endif
 * \if english
 * @brief Whether vtable is CxpHandlerClass type is confirmed.
 *
 * \endif
 */
#define CXP_IS_HANDLER_CLASS(vtable)	(G_TYPE_CHECK_CLASS_TYPE ((vtable), CXP_TYPE_HANDLER))

/**
 * \if japanese
 * @brief 󥹥inst顢CxpHandlerClass롣
 *
 * \endif
 * \if english
 * @brief The CxpHandlerClass type is obtained from instance inst. 
 *
 * \endif
 */
#define CXP_HANDLER_GET_CLASS(inst)		(G_TYPE_INSTANCE_GET_INTERFACE ((inst), CXP_TYPE_HANDLER, CxpHandlerClass))

	typedef struct
	{
		GObject parent;
	} CxpHandler;

	typedef struct
	{
		GObjectClass parent;
	} CxpHandlerClass;

/* used by CXP_TYPE_HANDLER */
	GType cxp_handler_get_type (void);

/*
 * Method definitions.
 */
	CxpHandler *cxp_handler_new (void);
	void cxp_handler_launch (CxpHandler *handler, const gchar *fullpath);
#ifdef __cplusplus
}
#endif

#endif				/* _CXP_HANDLER_H */
