module DarkHall
	class Switch < StorableObject
		def initialize
			@data = {}
		end

		def [](id)
			@data[id.to_s]
		end
		
		def []=(id, value)
			@data[id.to_s] = value
		end
		
		def keys
			@data.keys
		end
		
		def dump
			hash = super
			hash['data'] = @data
			return hash
		end
		
		def self.create_from_mpac_model(hash)
			obj = new
			hash['data'].each_pair do |key, value|
				obj[key] = value
			end
			return obj
		end
	end
end