require 'Win32API'

module FontList
  SHGetSpecialFolderPath =
    Win32API.new("shell32.dll","SHGetSpecialFolderPath", "LPLL","L")
  
  module_function
  
  def fontfiles
    path = " "*1024
    res = SHGetSpecialFolderPath.call(0, path, 0x14, 0)
    
    if res == 0
      raise "cannot find font path"
    end
    path = File.expand_path(path)
    
    Dir.open(path) do |dir|
      dir.find_all{|fname| File.fnmatch("*.tt*", fname)}.
        map{|fname| File.join(path, fname)}
    end
  end
end

if __FILE__ == $0
  puts FontList.fontfiles
end
