#! ruby -Ku
#-----------------------------------------------------------
# DarkHall Name Input Dialog (for multi-platform)
#
# Author:   Team D.H. <team.darkhall@gmail.com>
# License:  NYSL 0.9982 <http://www.kmonos.net/nysl/>
#           (unlike other files)
# URL:      http://wiz.morphball.net/darkhall/
#-----------------------------------------------------------
require './bootstrap.rb'

require 'wx'
require 'wxconstructor'

if $LOADED_FEATURES.include?('exerb/mkexy.rb') or defined?(ExerbRuntime) then
	require '__wxautoload'
end

require 'locale'
require 'gettext'

GetText.bindtextdomain('darkhall_system', :path => './data/locale')
include GetText



module NameInput
	MESSAGE = ARGV[0]
	unless MESSAGE then
		raise ArgumentError, 'no message for name input dialog.'
	end
	DEFAULT_VALUE = ARGV[1] || ''

	class App < Wx::App
		include GetText
		def on_init
			@dialog = MainDialog.new(nil, :title => s_('Dialog|名前の入力'))
			@dialog.show_modal
		end
	end
	
	class MainDialog < Wx::Dialog
		include GetText
		def initialize(*args)
			super
			self.window_style |= Wx::STAY_ON_TOP
			centre

			topsz = nil
			dialog = self
			construct_children do
				widget Wx::Panel do
					topsz = vbox_sizer do
						expand
						border 8
						widget Wx::StaticText, :label => MESSAGE
						text = widget Wx::TextCtrl, :name => 'name_input', :value => DEFAULT_VALUE
						text.set_focus
						
						hbox_sizer do
							stretch_spacer 1
							proportion 1
							but = widget Wx::Button, :label => s_('Dialog|決定')
							but.set_default
							dialog.evt_button(but, :on_decide)
							stretch_spacer 1
						end
					end
				end
			end
			
			topsz.fit(self)
			evt_close(:on_cancel)
		end
		
		def on_decide
			name = find_window_by_name('name_input').value
			$stdout.print(name)
			exit
		end
		
		def on_cancel
			exit
		end
	end
	
end

app = NameInput::App.new
unless $LOADED_FEATURES.include?('exerb/mkexy.rb') then
	app.main_loop
end