package daruma.geometry;

import daruma.geometry.CoordinateSystem;
import daruma.geometry.TransformationException;

public abstract class CoordinateSystemTransformation
{
    private String           identifier;
    private CoordinateSystem sourceCS;
    private CoordinateSystem targetCS;

    public CoordinateSystemTransformation( String identifier,
					   CoordinateSystem sourceCS,
					   CoordinateSystem targetCS )
    {
	this.identifier = identifier;
	this.sourceCS   = sourceCS;
	this.targetCS   = targetCS;
    }

    public final String getIdentifier()
    {
	return this.identifier;
    }

    public final CoordinateSystem getSourceCS()
    {
	return this.sourceCS;
    }

    public final CoordinateSystem getTargetCS()
    {
	return this.targetCS;
    }

    public abstract String getTransformName();

    public abstract String encode();

    public abstract DrmPoint transform( DrmPoint point )
	throws TransformationException;
}
