package daruma.storage_manager;

import daruma.util.LogWriter;

import daruma.storage_manager.StorageException;
import daruma.storage_manager.type_definition.ElementName;
import daruma.storage_manager.type_definition.TypeName;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.TypedInstance;
import daruma.storage_manager.type_definition.TypedInstanceSet;
import daruma.storage_manager.type_definition.ColumnNameFactory;

import daruma.storage_manager.schema.XMLSchemaSet;


// XXX: PredicateDescription should be moved to other package?
import daruma.wfs.filter.PredicateDescription;

import daruma.geometry.CoordinateSystem;
import daruma.geometry.CoordinateSystemTransformation;
import daruma.geometry.CoordinateSystemTransformationDictionary;
import daruma.geometry.TransformationContext;
import daruma.geometry.DrmEnvelope;

import daruma.xml.UniversalName;
import daruma.xml.SimpleXPath;
import daruma.xml.util.PrefixMap;
import daruma.util.Pair;

import org.w3c.dom.Element;

import java.util.Date;

import java.util.List;
import java.util.Map;

public abstract class StorageManager
{
    /* !!! [06/08/16 03:26 I.Noda] !!! 
     * Separator  ColumnNameFactory ˽
     */
    //private	static	final	String	SHORT_XPATH_SEPARATOR = "/";
    public static final String	SHORT_XPATH_SEPARATOR = 
	ColumnNameFactory.ColNameSep ;

	//
	// schema
	//
	public abstract void		registerSchema
					  ( Element  schema ,
					    PrefixMap  prefixMap )
						throws StorageException;
        /* <<< [06/09/07 16:53 I.Noda] <<< 
	 * ޤμϡñʤ륹ʸǤϤʤ
	 * DOM Element ʤɤβԤäΤ֤
	 * ޤط(Ʊ֤̾򥿡åȤȤΤ
	 * import ) ޤƱ˸֤
	 */
	//public abstract List<String>	getSchemasOfElement
	//				( ElementName  elementName )
	//					throws StorageException;
        //public abstract List<String> getSchemasByNS(String namespaceURI)
	//    throws StorageException ;
        /* === [06/09/07 16:53 I.Noda] === */
	public abstract XMLSchemaSet	getSchemasOfElement
					( ElementName  elementName )
	    throws StorageException;
	public abstract XMLSchemaSet	getSchemasOfElement
					( ElementName  elementName,
					  XMLSchemaSet schemaSet )
	    throws StorageException;

        public abstract XMLSchemaSet getSchemasByNS(String namespaceURI)
	    throws StorageException ;


        public abstract XMLSchemaSet getSchemasByNS(String namespaceURI,
						    XMLSchemaSet schemaSet)
	    throws StorageException ;
        /* >>> [06/09/07 16:53 I.Noda] >>> */
    
	//
	// type
	//
	public abstract void		registerTypeDefinition
					  ( TypeName  typeName ,
					    TypeDefinition  definition ,
					    String  schemaID ,
					    long  internalSchemaID ,
					    boolean  cacheUpdateOnly )
						throws StorageException;

	public abstract TypeDefinition	getTypeDefinition( TypeName  typeName )
						throws StorageException;



	//
	// element
	//
	public abstract void		registerElementDefinition
					  ( ElementName  elementName ,
					    TypeName  typeName ,
					    long  internalSchemaID ,
					    boolean  cacheUpdateOnly )
						throws StorageException;
	public abstract TypeName	getElementTypeName
					  ( ElementName  elementName )
						throws StorageException;

	public abstract	List<ElementName>	getElementList()
						throws StorageException;

	public abstract	void	insertElement( UniversalName  elementName ,
					       TypedInstance  obj,
					       long transactionSN)
						      throws StorageException;

	public abstract	TypedInstanceSet	getTypedInstanceSet
						 ( ElementName  elementName ,
						   /* Query */
						   String  sqlWhereBlock,
						   TransformationContext trans,

						   long limitCount)
						      throws StorageException;

        /* !!! [06/08/22 18:56 I.Noda] !!! */
	public abstract	long	getCountOfTypedInstanceSet
						  ( ElementName  elementName ,
						    /* Query */
						    String  sqlWhereBlock,
						    long limitCount)
						      throws StorageException;
        /* !!! [06/08/22 18:56 I.Noda] !!! */
        public abstract DrmEnvelope 
	    getEnvelopeOfTypedInstanceSet(ElementName elementName,
					  String propertyColName,
					  String sqlWhereBlock,
					  long limitCount)
	    throws StorageException;

	public abstract	void	deleteElement
				    ( UniversalName  elementName ,
				      PredicateDescription  predicate ,
				      long transactionSN,
				      boolean  virtualDelete )
						      throws StorageException;

	public	abstract void	restoreElement
				    ( UniversalName  elementName ,
				      PredicateDescription  predicate,
				      long transactionSN)
						      throws StorageException;

	public	abstract void	updateElement
				    ( UniversalName  elementName ,
				      List< Pair<SimpleXPath,String> >
							  updateValues ,
				      PredicateDescription  predicate ,
				      long transactionSN,
				      boolean  virtualUpdate )
						      throws StorageException;

	// XXX
	public abstract List<String>	getSubTableValues( String  tableName ,
							   long  parentID )
						      throws StorageException;

	//
	// universal name
	//
	public abstract	void	registerUniversalNameIfNotRegistrated
					  ( UniversalName  universalName )
						      throws StorageException;
	public abstract	String	getUniversalNameID( UniversalName  name )
						      throws StorageException;


	//
	// time
	//
	public	abstract Date	getCurrentTime() throws StorageException;

    /* !!! [06/08/17 17:28 I.Noda] !!! */
    // 
    // Transaction ID
    //
    public abstract long registerTransactionURI(String uri) 
	throws StorageException ;

    public abstract long getTransactionSerialNumber(String uri)
	throws StorageException ;

    public abstract String getMostRecentTransactionURI()
	throws StorageException ;

    /* !!! [06/08/22 02:35 I.Noda] !!! */
    public abstract String getMostRecentTransactionURIFor(String nsURI,
							  String localname)
	throws StorageException ;
    public abstract String getMostRecentTransactionURIFor(UniversalName uname)
	throws StorageException ;

	//
	// utility
	//
    /* !!! [06/08/16 03:26 I.Noda] !!! 
     *  XPath Ϥޤ db Ѥ̾ʤΤǡ
     * 줬᥽å̾ѹ
     */
    //public	String	getShortXPathString( SimpleXPath  path )
	public	String	getShortXPathStringForDB( SimpleXPath  path )
						     throws StorageException
	{
		StringBuilder	buf = new StringBuilder();

		for ( UniversalName  name  :  path.getList() )
		{
			try
			{
				if ( buf.length() != 0 )
				{
					buf.append
					    ( this.SHORT_XPATH_SEPARATOR );
				}

				String	id = this.getUniversalNameID( name );

				if ( id == null )
				{
					throw new StorageException
						( "Can't convert path ["
						  + path.toString() + "]" );
				}

				buf.append( id );
			}
			catch( StorageException  e )
			{
				throw e;
			}
		}

		if ( path.isAttribute() )
		{
			try
			{
				if ( buf.length() != 0 )
				{
					buf.append
					    ( this.SHORT_XPATH_SEPARATOR );
				}

				buf.append( ColumnNameFactory
					    .ColNameAttributePrefix );

				String	id = this.getUniversalNameID
						  ( path.getAttributeName() );

				if ( id == null )
				{
					throw new StorageException
						( "Can't convert path ["
						  + path.toString() + "]" );
				}

				buf.append( id );
			}
			catch( StorageException  e )
			{
				throw e;
			}
		}

		return( buf.toString() );
	}

	public	TypeDefinition	getElementTypeDefinition
					  ( ElementName  elementName )
						throws StorageException
	{
		TypeName	typeName;

		try
		{
			typeName = this.getElementTypeName( elementName );
		}
		catch( StorageException e )
		{
			throw new StorageException( "type of element \""
						   + elementName.getLocalName()
						   + "\" in namespace \""
						   + elementName.getNamespace()
						   + "\" not found" , e );
		}

		try
		{
			return( this.getTypeDefinition( typeName ) );
		}
		catch( StorageException e )
		{
			throw new StorageException
				( "type definition of type \""
				  + typeName.getLocalName()
				  + "\" in namespace \""
				  + typeName.getNamespace()
				  + "\" not found" , e );
		}
	}


	public abstract void registerCoordinateSystemTransformation
				( CoordinateSystemTransformation trans )
	    throws StorageException;

	public abstract CoordinateSystemTransformationDictionary
				getCoordTransDictionary()
	    throws StorageException;
}
