package daruma.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * Output stream that ignore "close()" call
 */
public class CloseIgnoreOutputStream extends FilterOutputStream
{
	public	CloseIgnoreOutputStream( OutputStream  o ) {
		super(o);
	}

	/**
	 * Do nothing and leave the stream.
	 */
	public	void	close() throws IOException {
		// do nothing
	}

	/**
	 * Really close the stream
	 */
	public	void	realClose() throws IOException {
		out.close();
	}
}
