/***
 *** Title: DeclaredName Utility
 *** Author: Itsuki Noda
 *** Date: 2006.08.18
 ***/

package daruma.util;

import java.util.UUID;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

import java.text.DateFormat ;
import java.text.SimpleDateFormat ;

import java.sql.Time;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

/* <<< [06/08/18 23:19 I.Noda] <<< 
 * for test
 */
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

import daruma.xml.*;
import daruma.xml.util.*;
import daruma.util.Pair;
/* >>> [06/08/18 23:19 I.Noda] >>> */


/**
 * ѥ桼ƥƥ饹
 */

public class Itk {
    //------------------------------------------------------------
    /**
     * ǥХåѽϥޥ
     */
    public static void dbgMsg(Object object) {
	try {
	    if(object == null) {
		dbgMsg("(null)") ;
	    } else if(object instanceof Node) {
		dbgMsg(XMLFormatConverter.toString((Node)object)) ;
	    } else {
		System.out.println("ITKDBG:" + object.toString()) ;
	    }
	} catch(TransformerException ex) {
	    ex.printStackTrace();
	}
    }


    public static void dbgMsg(String label, Object object) {
	try {
	    if(object == null) {
		dbgMsg(label, "(null)") ;
	    } else if(object instanceof Node) {
		dbgMsg(label, XMLFormatConverter.toString((Node)object)) ;
	    } else {
		System.out.println("ITKDBG[" + label + "]:" 
				   + object.toString()) ;
	    }
	} catch(TransformerException ex) {
	    ex.printStackTrace();
	}
    }

    //------------------------------------------------------------
    /**
     * UUID ˤ URI 
     */
    public static String genUriRandom() {
	UUID uuid = UUID.randomUUID() ;
	return "uri:uuid:" + uuid.toString() ;
    }

    //------------------------------------------------------------
    /**
     * ߻CalendarǼ
     */
    public static Calendar getCurrentTimeCalendar() {
	String tz = "JST" ;
	return Calendar.getInstance(TimeZone.getTimeZone(tz)) ;
    }

    //------------------------------------------------------------
    /**
     * ߻DateǼ
     */
    public static Date getCurrentTimeDate() {
	return new Date() ;
    }

    //------------------------------------------------------------
    /**
     * ߻TimeǼ
     */
    public static Time getCurrentTime() {
	return new Time(getCurrentTimeDate().getTime()) ;
    }

    //------------------------------------------------------------
    public static final String DefaultTimeStrFormatPattern 
	= "yyyy-MM-dd HH:mm:ss.SSS" ;
    public static final DateFormat DefaultTimeStrFormat 
	= new SimpleDateFormat(DefaultTimeStrFormatPattern) ;

    /**
     * ߻StringǼ
     */
    public static String getCurrentTimeStr() {
	return getCurrentTimeStr(DefaultTimeStrFormat) ;
    }

    public static String getCurrentTimeStr(String formatPattern) {
	return getCurrentTimeStr(new SimpleDateFormat(formatPattern)) ;
    }

    public static String getCurrentTimeStr(DateFormat form) {
	Date date = getCurrentTimeDate() ;
	return form.format(date) ;
    }

    //------------------------------------------------------------
    /**
     * Response 򡢲ǡprintlnˤľ񤭡ˤǽϤ뤫
     * (DOM)档
     * ǤΥƥȤΤᡣ
     * ޤԤСǤ졣
     */

    //public static final boolean useDOMResponse = false ;
    public static final boolean useDOMResponse = true ;

    /* !!! [06/10/17 03:57 I.Noda] !!! */
    //------------------------------------------------------------
    /**
     * GetFeature ˤơMySQL  BBOX ˤ븡̤
     * ̩ʾåˤ뤫ɤ
     * ǽŪˤ true
     */
    public static final boolean useDetailedCheck = false ;
    //public static final boolean useDetailedCheck = true ;

    //============================================================
    /**
     * ƥȥ롼
     */
    static public void test() {
	try {
	    Document doc = DOMDocumentFactory.create() ;

	    Element root =
		ElementUtil.genElementSimple(NameSpace.GML,
					      "root",
					      null,
					      doc,
					      doc) ;
	    Element child =
		ElementUtil.genElementSimple(NameSpace.GML,
					      "child",
					      "child's text",
					      doc,
					      root) ;
	    Pair<String,String> strHeaderTailer =
		ElementUtil.splitToHeaderTailerStrAt(doc, child, true) ;

	    XMLFormatConverter.print(root,System.out,true);
	    Itk.dbgMsg(strHeaderTailer.getFirst()) ;
	    Itk.dbgMsg(strHeaderTailer.getSecond()) ;
	} catch(ParserConfigurationException pce) {
	    pce.printStackTrace();
	} catch(TransformerException te) {
	    te.printStackTrace();
	}

    }

}
