package daruma.wfs;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.io.PrintWriter;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import daruma.util.CloseIgnoreInputStream;
import daruma.util.CountOutputStream;
import daruma.util.FatalException;
import daruma.util.LogWriter;

import daruma.wfs.SOAPHandler;
import daruma.xml.handler.MispDefaultHandler;
import daruma.xml.util.EndOfDocumentException;
import daruma.xml.util.XMLFormatConverter;
import daruma.storage_manager.StorageManager;

import daruma.util.Itk;


public class SOAPWFSProcessor
{
	private	String	debugTag = "";

	public	void	setDebugTag( String  debugTag )
	{
		this.debugTag = debugTag;
	}


	public	void	process( InputStream  in ,  OutputStream  out ,
				 StorageManager  storage )
					throws daruma.util.FatalException
	{
		LogWriter.qwrite("DEBUG", "debugTag = [", this.debugTag, "]" );

		CountOutputStream  cOut = new CountOutputStream( out );


		//
		// create parser
		//
		SAXParserFactory	f = SAXParserFactory.newInstance();
		f.setNamespaceAware( true );

		XMLReader		parser;
		MispDefaultHandler	h;

		try
		{
			parser = f.newSAXParser().getXMLReader();

			h = new SOAPHandler( cOut , parser , true , storage );

			h.setThrowEODWithEndOfTopLevelElement( true );

			/*
			h.setDebugFlag( true );
			*/

			parser.setContentHandler( h );
			parser.setErrorHandler( h );
		}
		catch( ParserConfigurationException  e )
		{
			throw new FatalException
				  ( "Can't create SAX parser" , e );
		}
		catch( SAXException  e )
		{
			throw new FatalException
				  ( "Can't create SAX parser" , e );
		}


		//
		// parse
		//
		try
		{
			PrintWriter	w = new PrintWriter( cOut );

			LogWriter.qwrite("DEBUG",  "parse start" );

			try
			{
				parser.parse
				  ( new InputSource
				    ( new CloseIgnoreInputStream( in ) ) );
			}
			catch( EndOfDocumentException  e )
			{
				LogWriter.qwrite("DEBUG",  "end of document" );
			}

			LogWriter.qwrite("DEBUG",  "parse succeeded" );

			w.flush();
			cOut.flush();
		}
		catch( SAXParseException  e )
		{
			LogWriter.qwrite("DEBUG",  "parse failed by parse error" );

			sendSOAPError( cOut , e , h.getResponse() ,
				       (cOut.getByteCount() == 0) );

			notifyParseError( e.getMessage() );
		}
		catch( SAXException  e )
		{
			LogWriter.qwrite("DEBUG",  "parse failed by misc error" );

			sendSOAPError( cOut ,
				       new SAXParseException
					   ( e.getMessage() ,
					     h.getLocator() ,
					     e ) ,
				       h.getResponse() ,
				       (cOut.getByteCount() == 0) );

			notifyParseError( e.getMessage() );
		}
		catch( IOException  e )
		{
			e.printStackTrace(System.err);
		}
	}


	private	static	void	notifyParseError( String  errorMessage )
	{
		LogWriter.qwrite("INFO", "xml parse error: ", errorMessage);
	}


	// XXX: tentative method, should send error document in SAX handler
	private	static	void	sendSOAPError( OutputStream  out ,
					       SAXParseException  exception ,
					       ResponseInfo  response ,
					       boolean  forceWrite )
    {
	PrintWriter w = new PrintWriter( out );

	try
	{
	    if ( forceWrite
	      || ! Itk.useDOMResponse )
	    {
		XMLFormatConverter.print( response.document , out );
	    }
	    else
	    {
		if(response.headerIsOutputedP)
		{
		    w.print(response.tailerStr);
		}
	    }
	}
	catch( TransformerException  e )
	{
	    e.printStackTrace();
	}

	try
	{
	    w.flush();
	    out.flush();
	}
	catch( IOException  e )
	{
	    e.printStackTrace();
	}
    }
}
