package daruma.wfs.filter;

import daruma.wfs.GetFeatureHandler;
import daruma.wfs.filter.PredicateDescription;
import daruma.wfs.filter.FilterParser;

import daruma.xml.SAXExceptionObserver;
import daruma.xml.handler.XSAXDOMCreateHandler;
import daruma.xml.util.XMLParseErrorException;

import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.TypeDefinition;

import daruma.geometry.TransformationContext;

import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import java.io.OutputStream;

public class FilterHandler extends XSAXDOMCreateHandler
{
    private	TypeDefinition		type;
    private	TransformationContext	trans;
    private	StorageManager		storage;
    private	SAXExceptionObserver	errorReceiver;

    private	PredicateDescription	predicate;

    public	FilterHandler( OutputStream  out ,
			       XMLReader  parser ,
			       boolean  isTopLevelHandler ,
			       TypeDefinition  type ,
			       TransformationContext  trans ,
			       StorageManager  storage ,
			       SAXExceptionObserver  errorReceiver )
    {
	super( out , parser , isTopLevelHandler );

	this.type          = type;
	this.trans         = trans;
	this.storage       = storage;
	this.errorReceiver = errorReceiver;
	this.predicate     = null;
    }

    /* !!! [06/10/16 15:34 I.Noda] !!! */
    //------------------------------------------------------------
    /**
     * DOM 뤿Υ󥿡ե
     * handler  delegate ȤȤ DOM Ǥʤ
     * 򤹤뤿Υ᥽åɡ
     * ʤ XSAXDOMCreateHanlder ǲ褵٤
     */
    public void xStartElement( String uri ,
			       String localName ,
			       String qName ,
			       Attributes  attrs ) throws SAXException
    {
	if(this.getCurrentNode() != null) {
	    /* !!! [06/10/16 15:34 I.Noda] !!! 
	     * parent handler (GetFeature) Ѥ DOM 뤿 
	     * Τwrapper Ƥ֡
	     * ʤΥΥȥåץ٥뤬줿ˤ
	     * Ǥ˿ƤϿƤΤǥåפ롣
	     * Τˡnull ӤƤ롣
	     *  darty hack ʤΤǡޤˡɬפ
	     *  XSAX Ǥ̵
	     */
	    /* !!! [06/10/18 11:02 I.Noda] !!! 
	     * quick hack
	     */
	    //((GetFeatureHandler)(this.getParentHandler()))
	    //	.xStartElementWrapper(uri,localName,qName,attrs);
	}

	/* !!! [06/10/16 15:34 I.Noda] !!! 
	 * ʬȤ DOM 뤿 super Ƥ֡
	 */
	super.xStartElement(uri,localName,qName,attrs);

    }

    /* !!! [06/10/16 15:34 I.Noda] !!! */
    //------------------------------------------------------------
    /**
     * DOM 뤿Υ󥿡ե
     * handler  delegate ȤȤ DOM Ǥʤ
     * 򤹤뤿Υ᥽åɡ
     * ʤ XSAXDOMCreateHanlder ǲ褵٤
     */
    public void  xCharacters( char[]  str , int  offset ,  int  length )
	throws SAXException
    {
	/* !!! [06/10/16 15:34 I.Noda] !!! 
	 * parent handler (GetFeature) Ѥ DOM 뤿 
	 * Τwrapper Ƥ֡
	 */
	/* !!! [06/10/18 11:02 I.Noda] !!! 
	 * quick hack
	 */
	//((GetFeatureHandler)(this.getParentHandler()))
	//    .xCharacters(str,offset,length);
	//((XSAXDOMCreateHandler)(this.getParentHandler()))
	//    .xCharacters(str,offset,length);
	/* !!! [06/10/16 15:34 I.Noda] !!! 
	 * ʬȤ DOM 뤿 super Ƥ֡
	 */
	super.xCharacters(str,offset,length);
    }

    //------------------------------------------------------------
    public PredicateDescription getPredicate()
    {
	return( this.predicate );
    }

    public String getSQLExpression()
    {
	if ( this.predicate == null )
	{
	    return( null );
	}

	return( this.predicate.getSQLExpression() );
    }

    public void xEndDocument() throws SAXException
    {
	Element	filterElement = super.getDocumentElement();

	try
	{
		this.predicate = FilterParser.parseFilter
					      ( filterElement ,
						this.type ,
						this.trans ,
						this.storage ,
						this.getPrefixMap() );
	}
	catch( XMLParseErrorException e )
	{
		SAXParseException	se = new SAXParseException
						 ( e.getMessage() ,
						   super.getLocator(), e );
		/* !!! [06/10/16 15:34 I.Noda] !!! 
		 * ΤSAXParseException Ǥϡ
		 * 줿 Exception Υåȥ졼
		 * ԡƤʤ
		 * ǡưǥԡ
		 */
		se.setStackTrace(e.getStackTrace());

		this.errorReceiver.notifyError( se );

		throw se;
	}
    }
    
    //--------------------------------------------------
    /**
     * ̩ʾå (2pass )
     */
    public boolean detailedCheck(Node feature) 
    	throws XMLParseErrorException
    {
	return this.predicate.detailedCheck(feature);
    }
}
