package daruma.wfs.filter.predicates;

import daruma.wfs.filter.PredicateDescription;
import daruma.wfs.filter.predicates.IntegratedPredicateDescription;
import daruma.wfs.filter.predicates.PropertyComparationPredicateDescription;
import daruma.wfs.filter.predicates.ImmidiateValueBooleanDescription;
import daruma.wfs.filter.predicates.LogicalPredicateDescription;
import daruma.wfs.filter.predicates.GeometryPredicateDescription;

import daruma.geometry.TransformationContext;

import daruma.xml.util.XMLParseErrorException;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.TypeDefinition;


//======================================================================
/**
 * Filter ΡɤνҸ쵭Ҥ祯饹
 */
public class IntegratedPredicateDescription extends PredicateDescription
{
    //--------------------------------------------------
    /**
     * Ѳǽʥɤå
     */
    public static boolean isAcceptablePredicate( String  localName )
    {
	return
	    (PropertyComparationPredicateDescription
	     .isAcceptablePredicate( localName )
	     || GeometryPredicateDescription
	     .isAcceptablePredicate( localName )
	     || ImmidiateValueBooleanDescription
	     .isAcceptablePredicate( localName )
	     || LogicalPredicateDescription
	     .isAcceptablePredicate( localName ) );
    }

    //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    /* ѿ
     */
    private String sqlExpression; /// ۲ filter  SQL ɽǼ 

    //--------------------------------------------------
    /**
     * 󥹥ȥ饯
     * 쵤 SQL ޤǺäƤޤʤäȰ´
     */
    public IntegratedPredicateDescription( Element  element ,
					   TypeDefinition  type ,
					   TransformationContext  trans ,
					   StorageManager  storage )
	throws XMLParseErrorException
    {
	super( storage , type , trans );

	this.sqlExpression = this.createSQLExpression( element );
    }

    //--------------------------------------------------
    /**
     * SQL ɽ
     */
    public String getSQLExpression()
    {
	return( this.sqlExpression );
    }

    //--------------------------------------------------
    /**
     * SQL ɽ
     */
    public String createSQLExpression( Element  element )
	throws XMLParseErrorException
    {
	String	localName = element.getLocalName();

	PredicateDescription child = null ;

	if ( PropertyComparationPredicateDescription
	     .isAcceptablePredicate( localName ) )
	{
	    child = 
		new PropertyComparationPredicateDescription
		( element ,
		  super.getTypeDefinition() ,
		  super.getTransformationContext() ,
		  super.getStorage() ) ;
	}
	else if ( GeometryPredicateDescription
		  .isAcceptablePredicate( localName ) )
	{
	    child = 
		new GeometryPredicateDescription
		( element ,
		  super.getTypeDefinition() ,
		  super.getTransformationContext() ,
		  super.getStorage() ) ;
	}
	else if ( ImmidiateValueBooleanDescription
		  .isAcceptablePredicate( localName ) )
	{
	    child = 
		new ImmidiateValueBooleanDescription
		( element ,
		  super.getTypeDefinition() ,
		  super.getTransformationContext() ,
		  super.getStorage() ) ;
	}
	else if ( LogicalPredicateDescription
		  .isAcceptablePredicate( localName ) )
	{
	    child =
		new LogicalPredicateDescription
		( element ,
		  super.getTypeDefinition() ,
		  super.getTransformationContext() ,
		  super.getStorage() ) ;
	}
	else
	{
	    throw new XMLParseErrorException
		( "cannot handle filter \"" + localName + "\"" );
	}

	this.addChild(child) ;

	return child.getSQLExpression() ;

    }

    //--------------------------------------------------
    /**
     * ܺ٥å
     * ʤɤΥå̩˹Ԥ2nd pass ν
     */
    public boolean detailedCheck(Node feature) 
    	throws XMLParseErrorException
    {
	if(this.numberOfChildren() > 0) {
	    return this.getChild(0).detailedCheck(feature) ;
	} else {
	    return true ;
	}
    }
}
