package daruma.xml.util;

import daruma.xml.SimpleXPath;
import daruma.xml.QName;
import daruma.xml.UniversalName;
import daruma.xml.util.PrefixMap;

public class TextUtil
{
	private	TextUtil()
	{
	}

	public	static	SimpleXPath	convertQNamePathToSimpleXPath
						( String  text ,
						  PrefixMap  prefixMap )
						throws XMLParseErrorException
	{
		String[]	propQNamePathList = text.trim().split( "/" );

		if ( propQNamePathList.length == 0 )
		{
			throw new XMLParseErrorException
				( "empty property path "
				  + "\"" + text + "\"" );
		}


		SimpleXPath	ret = new SimpleXPath();

		for ( String  propQNameString : propQNamePathList )
		{
			QName	q = new QName( propQNameString );

			if ( ! q.isValid() )
			{
				throw new XMLParseErrorException
					( "[" + propQNameString + "]"
					  + " is not a valid QName" );
			}

			String	namespaceURI = prefixMap.get( q.getPrefix() );

			ret.add( new UniversalName
				 ( namespaceURI , q.getLocalName() ) );
		}

		return( ret );
	}

	/*
	protected  String  convertPropertyToID( String  propertyNameString )
							throws SAXException
	{
		UniversalName	propertyName;

		try
		{
			propertyName = this.convertQNameStringToUniversalName
							( propertyNameString );
		}
		catch( SAXException  e )
		{
			throw e;
		}

		String	propertyID;
		try
		{
			propertyID = this.storage.getUniversalNameID
							( propertyName );

			if ( propertyID == null )
			{
				throw new SAXException
				  ( "property \"" + propertyNameString + "\""
				    + " not found" );
			}
		}
		catch( StorageException  e )
		{
			throw new SAXException( e.getMessage() , e );
		}

		return( propertyID );
	}

	protected  UniversalName  convertQNameStringToUniversalName
							( String  qNameString )
							    throws SAXException
	{
		QName	qName = new QName( qNameString );

		if ( ! qName.isValid() )
		{
			throw new SAXException( "invalid QName ["
						+ qNameString + "]" );
		}


		String	ns = prefixMap.get( qName.getPrefix() );

		if ( ns == null )
		{
			throw new SAXException( "unbounded prefix ["
						+ qName.getPrefix() + "] " );
		}

		return( new UniversalName( ns , qName.getLocalName() ) );
	}
	*/
}
