#ifndef	   BINARY_READER_H_INCLUDED
#define	   BINARY_READER_H_INCLUDED

// Author:		H. Shimora
// Created:		May 25 2004
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  May 25 2004    base version.
//
//

#include  "istream_compat_wrapper.h"
#include  <string>


class  Binary_Reader
{
private:
	std::istream &	in;

public:
	Binary_Reader( std::istream &  in )
		: in( in )
	{
	}

	bool	skip( size_t  n ,
		      size_t *  read_count = static_cast<size_t *>(0) )

	{
		// XXX: optimizable (istream.read())

		if ( read_count )
		{
			*read_count = 0;
		}

		for ( size_t  i = 0  ;  i < n  ;  i ++ )
		{
			char	ch;

			if ( ! in.get( ch ) )
			{
				return( false );
			}

			if ( read_count )
			{
				(*read_count) ++;
			}
		}

		return( true );
	}

	bool	read_2_bytes_unsigned_int_in_little_endian
		( unsigned short *  value ,
		  size_t *  read_count = static_cast<size_t>(0) )
	{
		*value = 0;

		if ( read_count )
		{
			*read_count = 0;
		}

		for ( int  i = 0  ;  i < 2  ;  i ++ )
		{
			char	ch;

			if ( ! in.get( ch ) )
			{
				return( false );
			}

			if ( read_count )
			{
				(*read_count) ++;
			}

			*value += (static_cast<unsigned char>(ch) << (8 * i));
		}

		return( true );
	}

	bool	read_2_bytes_signed_int_in_little_endian
		( short *  value ,
		  size_t *  read_count = static_cast<size_t>(0) )
	{
		unsigned short	u;
		bool	ret = read_2_bytes_unsigned_int_in_little_endian
				( &u , read_count );

		*value = static_cast<short>( u );

		return( ret );
	}

	bool	read_bytes( size_t  n ,  std::string *  data )
	{
		*data = "";

		// XXX: optimizable (istream.read())
		for ( size_t  i = 0  ;  i < n  ;  i ++ )
		{
			char	ch;

			if ( ! in.get( ch ) )
			{
				return( false );
			}

			(*data) += static_cast<unsigned char>(ch);
		}

		return( true );
	}
};


#endif	/* BINARY_READER_H_INCLUDED */
