#ifndef	   D2_POLYGON_H_INCLUDED
#define	   D2_POLYGON_H_INCLUDED

// Author:		H. Shimora
// Created:		Aug  2 2004
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Aug  2 2004    base version.
//
//

#include  "d2_vector.h"
#include  "d2_rectangle_region.h"
#include  "float_traits.h"
#include  <vector>

class  D2_Polygon
{
private:
	std::vector<D2_Vector>	vertex;


public:
		 D2_Polygon();
		 D2_Polygon( const std::vector<D2_Vector> &  v );
	virtual	~D2_Polygon();

	void	set( const std::vector<D2_Vector> &  v );
	void	set_empty();
	void	add( const D2_Vector &  p );

	const std::vector<D2_Vector> &	points() const;
	std::vector<D2_Vector> &	points();

	bool	intersect( const D2_Vector & p ,
			   bool  allow_on_segment = true ) const;

	void	get_bounding_box( D2_Rectangle_Region * ) const;

	D2_Vector	xy_center() const;

	FLOAT	get_distance( const D2_Vector &  p ,
			      bool  check_as_plane = true ) const;

	FLOAT	area() const;
	FLOAT	signed_area_2() const;
	bool	is_reverse_clockwise() const;
	bool	is_clockwise() const;

	void	get_scissored_connected_polygon
				( D2_Polygon *  result ,
				  const D2_Rectangle_Region &  r ) const;

#if 0
	void	get_scissored_polygons
				( std::vector<D2_Polygon> *  result ,
				  const D2_Rectangle_Region &  r ) const;
#endif

#if 0
	// XXX: not completed yet
	bool	get_overlap_polygon( std::vector<D2_Polygon> *  result ,
				     const D2_Polygon &  p ) const;
#endif

	bool	operator == ( const D2_Polygon &  p ) const;
	bool	operator != ( const D2_Polygon &  p ) const;
};


#endif	/* D2_POLYGON_H_INCLUDED */
