#ifndef	   D2_TRIANGLE_H_INCLUDED
#define	   D2_TRIANGLE_H_INCLUDED

// Author:		H. Shimora
// Created:		Jul 30 2004
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Jul 30 2004    base version.
//
//

#include  "d2_vector.h"
#include  "d2_segment.h"
#include  "float_traits.h"

class  D2_Triangle
{
private:
	D2_Vector	p0;
	D2_Vector	p1;
	D2_Vector	p2;

public:
	D2_Triangle( const D2_Vector &  p0 ,
		     const D2_Vector &  p1 ,
		     const D2_Vector &  p2 );

	D2_Triangle( const D2_Segment &  p01 ,
		     const D2_Vector &  p2 );

	FLOAT	signed_area() const;
	FLOAT	signed_area_2() const;

	FLOAT	area() const;
	FLOAT	area_2() const;

	bool	intersect( const D2_Vector & p ,
			   bool  allow_on_segment = true ) const;
};


#endif	/* D2_TRIANGLE_H_INCLUDED */
