#ifndef	   ASYNCHRONOUSBUF_H_INCLUDED
#define	   ASYNCHRONOUSBUF_H_INCLUDED

// Author:		H. Shimora
// Created:		Jan  6 2004
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Jan  6 2004    base version.
//
//

#ifdef HAVE_CONFIG_H
# include  "config.h"
#endif

#include  "streambuf_extension.h"
#include  <unistd.h> // for write()
#include  <cstdio>   // for BUFSIZ, EOF(XXX: should use char_traits<>::eof())
#include  <cstring>  // for memcpy()


class  asynchronousbuf : public streambuf_extension
{
private:
	 // not allowed.
	 asynchronousbuf( const asynchronousbuf & );

	 // not allowed.
	 asynchronousbuf &	operator= ( const asynchronousbuf & );


private:
	int	fd;
	char	buffer[BUFSIZ];

private:
	ssize_t	flush_output_buffer()
	{
		ssize_t	n = ::write( this -> fd ,
				     this -> output_buffer_begin() ,
				     this -> output_buffer_current()
				     - this -> output_buffer_begin() );

		if ( n > 0 )
		{
			this -> output_buffer_move_current( -n );
		}

		return( n );
	}

public:
	asynchronousbuf( int  fd )
		: fd( fd )
	{
		this -> initialize_output_buffer
			( this -> buffer , sizeof( this -> buffer ) );
	}

	~asynchronousbuf()
	{
		if ( ! this -> output_buffer_empty() )
		{
			this -> flush_output_buffer();
		}
	}

	int  overflow( int  ch = EOF )
	{
		if ( this -> flush_output_buffer() == -1 )
		{
			return( EOF );
		}

		if ( ch == EOF )
		{
			return( EOF );
		}

		*(this -> output_buffer_current())
				= static_cast<unsigned char>( ch );
		this -> output_buffer_move_current( 1 );

		return( ch );
	}

	std::streamsize	xsputn( const char *  str ,  std::streamsize  n )
	{
		int	indx = 0;

		while( indx < n )
		{
			int	copy_size = this -> output_buffer_remain();

			if ( copy_size > n - indx )
			{
				copy_size = n - indx;
			}

			std::memcpy( this -> output_buffer_current() ,
				     str + indx , copy_size );

			indx += copy_size;

			this -> output_buffer_move_current( copy_size );

			if ( this -> output_buffer_full() )
			{
				if ( this -> flush_output_buffer() == -1 )
				{
					return( EOF );
				}
			}
		}

		return( n );
	}
};


#endif	/* ASYNCHRONOUSBUF_H_INCLUDED */
