#include  "echo_interpreter.h"
#include  "posix_compat_socket_headers.h"
#include  <cstdio>
#include  <iostream>


Echo_Interpreter::Echo_Interpreter( int  fd )
	: fd( fd ) , quit_flag( false )
{
}

Echo_Interpreter::~Echo_Interpreter()
{
}

bool   Echo_Interpreter::valid() const
{
	return( ! this -> quit_flag );
}

void   Echo_Interpreter::interpret( General_Server & )
{
	char	buf[BUFSIZ];
	ssize_t	n_read;

	switch( (n_read = recv( this -> fd , buf , sizeof( buf ) , 0 )) )
	{
	case -1:
		std::perror( "recv" );
		this -> quit_flag = true;
		return;
		break;

	case 0:
		this -> quit_flag = true;
		return;
		break;

	default:
		break;
	}


	ssize_t	send_count = 0;

	while( send_count < n_read )
	{
		int	n_send;

		switch( (n_send = ::send( fd ,
					  static_cast<const char *>(buf)
							      + send_count ,
					  n_read - send_count ,
					  0 )) )
		{
		case -1:
			std::perror( "send" );
			return;

		case 0:
			return;
			break;

		default:
			send_count += n_send;
			break;
		}
	}
}
