#include  "process_environment.h"
#include  <cstdio>
#include  <unistd.h>
#include  <fcntl.h>

const char *	Process_Environment::NULL_DEVICE_PATH = "/dev/null";
const char *	Process_Environment::ROOT_PATH = "/";

bool   Process_Environment::switch_to_background()
{
#ifdef TENTATIVE_HACK_FOR_ONLY_MINGW_COMPILE
	return( false );
#else
	switch( ::fork() )
	{
	case  -1:
		// error
		std::perror( "fork" );

		return( false );
		break;

	case  0:
		// child process
		break;

	default:
		// parent process
		::_exit( 0 );
		return( false );
		break;
	}

	return( true );
#endif
}


bool   Process_Environment::switch_to_daemon_environment()
{
	if ( ! Process_Environment::switch_to_background() )
	{
		return( false );
	}


#ifndef TENTATIVE_HACK_FOR_ONLY_MINGW_COMPILE
	if ( ::setsid() == -1 )
	{
		std::perror( "setsid" );
	}
#endif


	if ( ::chdir( Process_Environment::ROOT_PATH ) == -1 )
	{
		std::perror( "chdir" );
	}


	int	null_fd;

	if ( (null_fd = ::open( Process_Environment::NULL_DEVICE_PATH ,
				O_RDWR )) == -1 )
	{
		std::perror( "open" );

		return( false );
	}

	if ( ::dup2( null_fd , STDIN_FILENO  ) == -1
	  || ::dup2( null_fd , STDOUT_FILENO ) == -1
	  || ::dup2( null_fd , STDERR_FILENO ) == -1 )
	{
		// may not report this because of dup2()
		std::perror( "dup2" );

		return( false );
	}

	if ( null_fd > 2 )
	{
		if ( ::close( null_fd ) == -1 )
		{
			// cannot report because stderr is closed.
			return( false );
		}
	}


	return( true );
}
