#include  "mmap_fstream.h"
#include  "test_environment.h"

static	void	prepare_test_file( const char *  file_name ,
				   const std::string &  contents ,
				   Test_Environment *  t );

int    main( void )
{
	Test_Environment	t;


	static	const char *	test_file_name = "test-file";

	{
		prepare_test_file( test_file_name , "3.14 2.72" , &t );

		mmap_ifstream	m( test_file_name );
		double	value = 0.0;
		m >> value;

		t.Assert_Nearly_Equals( 3.14 , value );
		t.Assert_Equals( true , static_cast<bool>( m ) );

		m >> value;
		t.Assert_Nearly_Equals( 2.72 , value );
		t.Assert_Equals( true , static_cast<bool>( m ) );

		m >> value;
		t.Assert_Equals( false , static_cast<bool>( m ) );
	}


	{
		prepare_test_file( test_file_name , "1abc" , &t );

		mmap_ifstream	m( test_file_name );
		int	i = 0;

		m >> i;
		t.Assert_Equals( 1 , i );

		char	ch = '\0';
		m >> ch;
		t.Assert_Equals( 'a' , ch );
	}


	{
		prepare_test_file( test_file_name , "\xfe" , &t );

		mmap_ifstream	m( test_file_name );
		char	ch = '\0';

		m.get( ch );
		t.Assert( m );

		t.Assert_Equals( static_cast<char>(0xfe) , ch );
	}


	{
		prepare_test_file( test_file_name , "\xff" , &t );

		mmap_ifstream	m( test_file_name );
		char	ch = '\0';

		m.get( ch );
		t.Assert( m );

		t.Assert_Equals( static_cast<char>(0xff) , ch );
	}


	{
		prepare_test_file( test_file_name , "" , &t );

		mmap_ifstream	m( test_file_name );

		t.Assert( m );
	}


	return( t.exit_status() );
}


#include  <fstream>
#include  <string>
#include  "test_environment.h"

static
void   prepare_test_file( const char *  file_name ,
			  const std::string &  contents ,
			  Test_Environment *  t )
{
	std::ofstream	new_file( file_name );

	t -> Assert_Critical( new_file ,
			      std::string() + "Can't open file \""
					    + file_name + "\" for writing." );

	new_file << contents;
}
