#include  "path.h"
#include  "string_extension.h"
#include  <iostream>

const std::string	Path::SEPARATOR = "/";


Path::Path( const std::vector<std::string> &  path ,
	    bool  relative_flag )
	: path( path ) , relative_flag( relative_flag )
{
}

Path::Path( const std::string &  path_string )
	: path() , relative_flag( true )
{
	if ( ! path_string.empty()
	  && path_string[0] == '/' )
	{
		this -> relative_flag = false;

		std::string	str( path_string.begin() + 1 ,
				     path_string.end() );

		String_Extension::split_by_char_set
			( &path , str , "/" );
	}
	else
	{
		this -> relative_flag = true;

		String_Extension::split_by_char_set
			( &path , path_string , "/" );
	}
}

Path::Path( const std::vector<std::string>::const_iterator &  begin ,
	    const std::vector<std::string>::const_iterator &  end ,
	    bool  relative_flag )
	: path( begin , end ) , relative_flag( relative_flag )
{
}

bool   Path::valid() const
{
	// XXX
	return( true );
}

bool   Path::operator == ( const Path &  p ) const
{
	if ( this -> size() != p.size()
	  || this -> relative() != p.relative() )
	{
		return( false );
	}

	for ( size_t  i = 0  ;  i < this -> size()  ;  i ++ )
	{
		if ( (*this)[i] != p[i] )
		{
			return( false );
		}
	}

	return( true );
}

bool   Path::operator != ( const Path &  p ) const
{
	return( ! (*this == p) );
}

bool   Path::relative() const
{
	return( this -> relative_flag );
}

bool    Path::absolute() const
{
	return( ! this -> relative() );
}

size_t  Path::size() const
{
	return( path.size() );
}

const std::string &  Path::operator[] ( size_t  i ) const
{
	return( path[i] );
}

Path::operator std::vector<std::string>() const
{
	return( path );
}

Path   Path::dir() const
{
	std::vector<std::string>	ret;

	for ( size_t  i = 0  ;  i < path.size() - 1  ;  i ++ )
	{
		ret.push_back( path[i] );
	}

	return( Path( ret , this -> relative() ) );
}

std::string  Path::file() const
{
	if ( path.empty() )
	{
		return( "" );
	}

	return( *(path.rbegin()) );
}

Path   Path::add( const Path &  p ) const
{
	std::vector<std::string>	ret = this -> path;

	for ( size_t  i = 0  ;  i < p.size()  ;  i ++ )
	{
		ret.push_back( p[i] );
	}

	return( Path( ret , this -> relative() ) );
}




Path   Path::operator + ( const Path &  p ) const
{
	return( this -> add( p ) );
}

std::string  Path::str() const
{
	std::string	ret;

	if ( this -> absolute() )
	{
		ret += SEPARATOR;
	}
	else
	{
		if ( path.empty() )
		{
			return( "." );
		}
	}

	for ( size_t  i = 0  ;  i < path.size()  ;  i ++ )
	{
		if ( i != 0 )
		{
			ret += SEPARATOR;
		}

		ret += path[i];
	}

	return( ret );
}

std::string  Path::native_string() const
{
	// XXX
	return( this -> str() );
}

Path::operator std::string() const
{
	return( this -> str() );
}


// extern
std::ostream &  operator<< ( std::ostream &  ostrm ,
			     const Path &  path )
{
	ostrm << static_cast<const std::string>( path );

	return( ostrm );
}

// class static
Path	Path::CURRENT_DIR()
{
	return( Path( "." ) );
}
