#ifndef	   SOCKSTREAMBUF_H_INCLUDED
#define	   SOCKSTREAMBUF_H_INCLUDED

// Author:		H. Shimora
// Created:		Sep 15 2007
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Sep 15 2007    base version.
//
//

#ifdef HAVE_CONFIG_H
# include  "config.h"
#endif

#include  "fdstreambuf.h"
#include  "stream_socket.h"
#include  "ip_address.h"
#include  <string>

class  sockstreambuf : public fdstreambuf
{
private:
	Stream_Socket	socket;

public:
	sockstreambuf( const std::string &  host ,
		       port_number_t  port ,
		       bool  ipv4_only = false )
	{
		this -> connect( host , port , ipv4_only );
	}

	sockstreambuf()
	{
	}

	virtual	~sockstreambuf() {}

	virtual	sockstreambuf *	connect( const std::string &  host ,
					 port_number_t  port ,
					 bool ipv4_only = false )
	{
		if ( this -> socket.make_connection
			     ( host , port , ipv4_only ) != -1 )
		{
			this -> fdstreambuf::set_fd( socket.fd() );
		}

		return( this );
	}
};


#endif	/* SOCKSTREAMBUF_H_INCLUDED */
