#ifndef	   STREAM_SOCKET_WRAPPER_H_INCLUDED
#define	   STREAM_SOCKET_WRAPPER_H_INCLUDED

// Author:		H. Shimora
// Created:		Jun  8 2002
// Version:		0.00

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.00  Jun  8 2002    base version.
//

#include  "stream_socket.h"
#include  "ref_count_ptr.h"
#include  <string>

class  Stream_Socket_Wrapper
{
private:
	mutable	ref_count_ptr<Stream_Socket>	sock;

	mutable	bool				have_newline;
	mutable	std::string			line;

private:
	bool	internal_read_char( bool  block );

public:
	Stream_Socket_Wrapper( const ref_count_ptr<Stream_Socket> &  sock
			       = static_cast<Stream_Socket *>(0) );

	void	handle( const ref_count_ptr<Stream_Socket> &  sock );

	operator bool () const;
	bool	valid() const;

	ref_count_ptr<Stream_Socket>	socket() const;
	int				fd() const;
	bool				poll() const;
	void				close();
	int				set_close_on_exec();
	bool				connected() const;
	bool				input_eof() const;
	bool				output_eof() const;

	bool				line_completed() const;
	std::string			get_line();

	void				recv_message( std::string *  mes );

	void				send_message
					  ( const std::string &  mes ) const;
};


#endif	/* STREAM_SOCKET_WRAPPER_H_INCLUDED */
