#include  "string_extension.h"
#include  <string>
#include  <vector>
#include  <iostream>
#include  <cassert>


int    main( void )
{
	//
	// chomp()
	//
	{
		{
			std::string	str = "abcdefg\n";

			assert( String_Extension::chomp(str) == "abcdefg" );
			assert( str == "abcdefg\n" );
		}

		{
			std::string	str = "abcdefg\n";

			String_Extension::chomp(&str);

			assert( str == "abcdefg" );
		}

		{
			std::string	str = "abcdefg\r\n";

			String_Extension::chomp(&str);

			assert( str == "abcdefg" );
		}

		{
			assert( String_Extension::chomp( ""     ) == ""    );
			assert( String_Extension::chomp( "\n"   ) == ""    );
			assert( String_Extension::chomp( "\r\n" ) == ""    );
			assert( String_Extension::chomp( "\n\n" ) == "\n"  );
			assert( String_Extension::chomp( "\n\r" ) == "\n"  );
			assert( String_Extension::chomp( "\na" )  == "\na" );
		}
	}


	//
	// split()
	//
	{
		std::vector<std::string>	v;

		String_Extension::split_by_char_set( &v ,
						     "abc-def-ghi" , "-" );

		assert( v.size() == 3 );
		assert( v[0] == "abc" );
		assert( v[1] == "def" );
		assert( v[2] == "ghi" );


		String_Extension::split_by_char_set
			( &v , "-abc-def-ghi-" , "-" , true );

		assert( v.size() == 3 );
		assert( v[0] == "abc" );
		assert( v[1] == "def" );
		assert( v[2] == "ghi" );
	}


	//
	// more split()
	//
	{
		std::vector<std::string>	v;


		{
			String_Extension::split_by_char_set
				( &v , "" , "-" );

			assert( v.empty() );
		}


		{
			String_Extension::split_by_char_set
				( &v , "abc-def--" , "-" );

			assert( v.size() == 3 );
			assert( v[0] == "abc" );
			assert( v[1] == "def" );
			assert( v[2] == "" );
		}

		{
			String_Extension::split_by_char_set
				( &v , "--abc-def" , "-" );

			assert( v.size() == 3 );
			assert( v[0] == "" );
			assert( v[1] == "abc" );
			assert( v[2] == "def" );
		}

		{
			String_Extension::split_by_char_set
				( &v , "--abc-def--" , "-" );

			assert( v.size() == 4 );
			assert( v[0] == "" );
			assert( v[1] == "abc" );
			assert( v[2] == "def" );
			assert( v[3] == "" );
		}


		{
			String_Extension::split_by_char_set
				( &v , "a" , "-" );

			assert( v.size() == 1 );
			assert( v[0] == "a" );
		}

		{
			String_Extension::split_by_char_set
				( &v , "-*-a*bc*" , "-*" );

			assert( v.size() == 4 );
			assert( v[0] == "" );
			assert( v[1] == "a" );
			assert( v[2] == "bc" );
			assert( v[3] == "" );
		}
	}


	//
	// join()
	//
	{
		std::vector<std::string>	val;

		assert( String_Extension::join( "/" , val ) == "" );

		val.push_back( "aaa" );
		assert( String_Extension::join( "/" , val ) == "aaa" );

		val.push_back( "bbb" );
		assert( String_Extension::join( "/" , val ) == "aaa/bbb" );
	}


	//
	// string_to_integer()
	//
	{
		int	value = 0;
		bool	succeeded = String_Extension::string_to_integer
							    ( &value , "5" );

		assert( succeeded == true );
		assert( value == 5 );
	}


	//
	// string_to_long()
	//
	{
		long	value = 0;
		bool	succeeded = false;

		{
			succeeded = String_Extension::string_to_long
							( &value , "5" );
			assert( succeeded == true );
			assert( value == 5 );
		}

		{
			succeeded = String_Extension::string_to_long
							( &value , "123456" );
			assert( succeeded == true );
			assert( value == 123456 );
		}

		{
			succeeded = String_Extension::string_to_long
							( &value , "-123456" );
			assert( succeeded == true );
			assert( value == -123456 );
		}

		{
			succeeded = String_Extension::string_to_long
							( &value , "a12" );
			assert( succeeded == false );
		}

		{
			succeeded = String_Extension::string_to_long
							( &value , "12a" );
			assert( succeeded == false );
		}

		{
			succeeded = String_Extension::string_to_long
							( &value , "" );
			assert( succeeded == false );
		}
	}


	//
	// string_to_int64_t()
	//
	{
		int64_t	value = 0;
		bool	succeeded = false;

		{
			succeeded = String_Extension::string_to_int64_t
							( &value , "5" );
			assert( succeeded == true );
			assert( value == 5 );
		}

		{
			succeeded = String_Extension::string_to_int64_t
							( &value , "123456" );
			assert( succeeded == true );
			assert( value == 123456 );
		}

		{
			succeeded = String_Extension::string_to_int64_t
							( &value , "-123456" );
			assert( succeeded == true );
			assert( value == -123456 );
		}

		{
			succeeded = String_Extension::string_to_int64_t
							( &value , "a12" );
			assert( succeeded == false );
		}

#if 0
		{
			succeeded = String_Extension::string_to_int64_t
							( &value , "12a" );
			assert( succeeded == false );
		}
#endif

		{
			succeeded = String_Extension::string_to_int64_t
							( &value , "" );
			assert( succeeded == false );
		}
	}


	//
	// string_to_double()
	//
	{
		double	value = 0.0;
		bool	succeeded = String_Extension::string_to_double
							( &value , "5.0" );

		assert( succeeded == true );
		assert( 5.0 - 0.01 < value && value < 5.0 + 0.01 );
	}


	//
	// double_to_string()
	//
	{
		std::string	result;

		String_Extension::double_to_string( &result , 3.14 );

		double	value = 0.0;
		bool	succeeded = String_Extension::string_to_double
							( &value , result );

		assert( succeeded == true );
		assert( 3.14 - 0.01 < value && value < 3.14 + 0.01 );
	}


	//
	// int64_t_to_string()
	//
	{
		std::string	result;

		String_Extension::int64_t_to_string
			( &result , 12345 );
		assert( result == "12345" );


		String_Extension::int64_t_to_string
			( &result , 0 );
		assert( result == "0" );


		int64_t	test_value = int64_t( 1234567890L ) * 100 + 12;

		String_Extension::int64_t_to_string
			( &result , test_value );
		assert( result == "123456789012" );

		String_Extension::int64_t_to_string
			( &result , - test_value );
		assert( result == "-123456789012" );
	}


	//
	// chomp_an_extension()
	//
	{
		assert( String_Extension::chomp_an_extension
			( "abc.def" ) == "abc" );

		assert( String_Extension::chomp_an_extension
			( "a.d" ) == "a" );

		assert( String_Extension::chomp_an_extension
			( ".def" ) == "" );

		assert( String_Extension::chomp_an_extension
			( "abc" ) == "abc" );

		assert( String_Extension::chomp_an_extension
			( "" ) == "" );
	}

	//
	// cutoff_edge()
	//
	{
		assert( String_Extension::cutoff_edge( "" , "\t" ) == "" );

		assert( String_Extension::cutoff_edge
			( "abc" , " \t" ) == "abc" );

		assert( String_Extension::cutoff_edge
			( " abc def " , " \t" ) == "abc def" );

		assert( String_Extension::cutoff_edge
			( "  abc def  " , " \t" ) == "abc def" );

		assert( String_Extension::cutoff_edge
			( " " , " \t" ) == "" );

		assert( String_Extension::cutoff_edge
			( "  " , " \t" ) == "" );

		assert( String_Extension::cutoff_edge
			( " \t " , " \t" ) == "" );

		assert( String_Extension::cutoff_edge
			( " a " , " \t" ) == "a" );

		assert( String_Extension::cutoff_edge
			( "  a  " , " \t" ) == "a" );

		assert( String_Extension::cutoff_edge
			( "a " , " \t" ) == "a" );

		assert( String_Extension::cutoff_edge
			( " a" , " \t" ) == "a" );

		assert( String_Extension::cutoff_edge
			( "abcdefg" , "d" ) == "abcdefg" );

		assert( String_Extension::cutoff_edge
			( "abcdefg" , "a" ) == "bcdefg" );

		assert( String_Extension::cutoff_edge
			( "aabcdefg" , "a" ) == "bcdefg" );

		assert( String_Extension::cutoff_edge
			( "\nabc\ndef\n" , "\n" ) == "abc\ndef" );
	}


	//
	// cutoff_edge_spaces()
	//
	{
		assert( String_Extension::cutoff_edge_spaces( "" ) == "" );

		assert( String_Extension::cutoff_edge_spaces
			( "abc" ) == "abc" );

		assert( String_Extension::cutoff_edge_spaces
			( " abc def " ) == "abc def" );

		assert( String_Extension::cutoff_edge_spaces
			( "  abc def  " ) == "abc def" );

		assert( String_Extension::cutoff_edge_spaces
			( " " ) == "" );

		assert( String_Extension::cutoff_edge_spaces
			( "  " ) == "" );

		assert( String_Extension::cutoff_edge_spaces
			( " \t " ) == "" );

		assert( String_Extension::cutoff_edge_spaces
			( " a " ) == "a" );

		assert( String_Extension::cutoff_edge_spaces
			( "  a  " ) == "a" );

		assert( String_Extension::cutoff_edge_spaces
			( "a " ) == "a" );

		assert( String_Extension::cutoff_edge_spaces
			( " a" ) == "a" );

		assert( String_Extension::cutoff_edge_spaces
			( "\nabc\ndef\n" ) == "abc\ndef" );
	}


	//
	// starts_with()
	//
	{
		assert(   String_Extension::starts_with( "a"    , "abc"  ) );
		assert(   String_Extension::starts_with( ""     , "abc"  ) );
		assert(   String_Extension::starts_with( "abc"  , "abcd" ) );
		assert(   String_Extension::starts_with( "abc"  , "abc"  ) );

		assert( ! String_Extension::starts_with( "abcd" , "abc"  ) );
		assert( ! String_Extension::starts_with( "-"    , "abc"  ) );
	}

	//
	// ends_with()
	//
	{
		assert(   String_Extension::ends_with( "c"    , "abc"  ) );
		assert(   String_Extension::ends_with( ""     , "abc"  ) );
		assert(   String_Extension::ends_with( "bcd"  , "abcd" ) );
		assert(   String_Extension::ends_with( "abc"  , "abc"  ) );
		assert( ! String_Extension::ends_with( "abcd" , "bcd"  ) );
		assert( ! String_Extension::ends_with( "-"    , "abc"  ) );
	}

	//
	// separate_to_2_parts
	//
	{
		std::string	first;
		std::string	second;
		bool		succeed = false;

		succeed = String_Extension::separate_to_2_parts
			  ( &first , &second , "abc=def" , '=' );
		assert( succeed );
		assert( first == "abc" );
		assert( second == "def" );


		succeed = String_Extension::separate_to_2_parts
			  ( &first , &second , "abcdef" , '=' );
		assert( ! succeed );
		assert( first == "" );
		assert( second == "" );


		succeed = String_Extension::separate_to_2_parts
			  ( &first , &second , "=" , '=' );
		assert( succeed );
		assert( first == "" );
		assert( second == "" );


		succeed = String_Extension::separate_to_2_parts
			  ( &first , &second , "a=b=c" , '=' );
		assert( succeed );
		assert( first == "a" );
		assert( second == "b=c" );


		succeed = String_Extension::separate_to_2_parts
			  ( &first , &second , "a=" , '=' );
		assert( succeed );
		assert( first == "a" );
		assert( second == "" );


		succeed = String_Extension::separate_to_2_parts
			  ( &first , &second , "=b" , '=' );
		assert( succeed );
		assert( first == "" );
		assert( second == "b" );

		succeed = String_Extension::separate_to_2_parts
			  ( &first , &second , "" , '=' );
		assert( ! succeed );
		assert( first == "" );
		assert( second == "" );
	}


	//
	// toupper, tolower, capitalize_first
	//
	{
		assert( "AAA_BBB" == String_Extension::toupper( "AaA_bbB" ) );

		assert( "aaa_bbb" == String_Extension::tolower( "AaA_bbB" ) );

		assert( "Aaa_bbb"
			== String_Extension::capitalize_first( "aaa_bbb" ) );
	}


	//
	// unquote
	//
	{
		bool	succeed = false;
		std::string	result;

		succeed = String_Extension::unquote( &result , "aaa" );
		assert( succeed );
		assert( result == "aaa" );

		succeed = String_Extension::unquote( &result , "\"aaa\"" );
		assert( succeed );
		assert( result == "aaa" );

		succeed = String_Extension::unquote
			( &result , "\"aaa\"bbb\"ccc\"" );
		assert( succeed );
		assert( result == "aaabbbccc" );
	}


	//
	// replace
	//
	{
		assert( "aaa::bbb::ccc"
			== String_Extension::replace
			   ( "aaa.bbb.ccc" , '.' , "::") );

		assert( "aaa..bbb..ccc"
			== String_Extension::replace
			   ( "aaa.bbb.ccc" , '.' , "..") );
	}


	//
	// repeat_string
	//
	{
		assert( "abcabcabc"
			== String_Extension::repeat_string( "abc" , 3 ) );

		assert( ""
			== String_Extension::repeat_string( "abc" , 0 ) );

		assert( ""
			== String_Extension::repeat_string( "" , 3 ) );
	}


	std::cout << "All tests succeeded !!" << std::endl;

	return( 0 );
}
