#ifdef    TIME_STAMP_TEST
#include  "time_stamp.h"
#include  <iostream>

extern "C"
{
	#include  <unistd.h>
}

using namespace std;

int    main( void )
{
	Time_Stamp	stamp_1;
	Time_Stamp	stamp_2;

	stamp_1.set_current_time();
	sleep( 1 );
	stamp_2.set_current_time();

	Time_Stamp::Time_Diff	diff = stamp_2 - stamp_1;

	cout << diff.usec() << endl;

	return( 0 );
}
#endif // TIME_STAMP_TEST



//
// Time_Stamp
//
#include  "time_stamp.h"
#include  <cstdio>
using namespace std;

Time_Stamp::Time_Stamp()
{
	this -> second   = 0;
	this -> u_second = 0;
}

Time_Stamp::Time_Stamp( First_State )
{
	this -> second   = 0;
	this -> u_second = 0;

	this -> set_current_time();
}

Time_Stamp::Time_Stamp( time_t  s ,  long  u )
{
	this -> second   = s;
	this -> u_second = u;
}

Time_Stamp::Time_Stamp( const struct timeval &  tv )
{
	this -> second   = tv.tv_sec;
	this -> u_second = tv.tv_usec;
}

Time_Stamp::~Time_Stamp()
{
}


const Time_Stamp &   Time_Stamp::normalize() const
{
	while( this -> u_second >= (1000 * 1000) )
	{
		this -> u_second -= (1000 * 1000);
		this -> second ++;
	}

	while( this -> u_second  <  0 )
	{
		this -> u_second += (1000 * 1000);
		this -> second --;
	}

	return( *this );
}


int  Time_Stamp::set_current_time()
{
#ifdef TENTATIVE_HACK_FOR_ONLY_MINGW_COMPILE
	return( -1 );
#else
	struct timeval	current_time;

	int	ret;

	if ( (ret = ::gettimeofday( &current_time , NULL )) == -1 )
	{
		std::perror( "gettimeofday" );

		this -> second   = 0;
		this -> u_second = 0;
	}
	else
	{
		this -> second   = current_time.tv_sec;
		this -> u_second = current_time.tv_usec;
	}

	return( ret );
#endif
}


time_t  Time_Stamp::sec() const
{
	this -> normalize();

	return( second );
}

long    Time_Stamp::usec() const
{
	this -> normalize();

	return( u_second );
}


Time_Stamp  Time_Stamp::forward_sec( time_t  s ) const
{
	return( Time_Stamp( second + s , u_second ).normalize() );
}

Time_Stamp  Time_Stamp::forward_msec( long  m ) const
{
	return( Time_Stamp( second , u_second + m * 1000 ).normalize() );
}

Time_Stamp  Time_Stamp::forward_usec( long  u ) const
{
	return( Time_Stamp( second , u_second + u ).normalize() );
}

Time_Stamp  Time_Stamp::backward_sec ( time_t  s ) const
{
	return( Time_Stamp( second - s , u_second ).normalize() );
}

Time_Stamp  Time_Stamp::backward_msec( long  m ) const
{
	return( Time_Stamp( second , u_second - m * 1000 ).normalize() );
}

Time_Stamp  Time_Stamp::backward_usec( long  u ) const
{
	return( Time_Stamp( second , u_second - u ).normalize() );
}


Time_Stamp::Time_Diff  Time_Stamp::operator - ( const Time_Stamp &  t ) const
{
	return( Time_Diff( this ->   second - t.  second ,
			   this -> u_second - t.u_second ) );
}


bool   Time_Stamp::operator == ( const Time_Stamp &  t ) const
{
	this -> normalize();
	t.normalize();

	return(    this ->   second == t.  second
		&& this -> u_second == t.u_second );

}

bool   Time_Stamp::operator != ( const Time_Stamp &  t ) const
{
	this -> normalize();
	t.normalize();

	return(    this ->   second != t.  second
		|| this -> u_second != t.u_second );
}



bool   Time_Stamp::operator < ( const Time_Stamp &  t ) const
{
	this -> normalize();
	t.normalize();

	if ( this -> second != t.second )
	{
		return( this -> second < t.second );
	}
	else
	{
		return( this -> u_second < t.u_second );
	}
}


bool   Time_Stamp::operator > ( const Time_Stamp &  t ) const
{
	this -> normalize();
	t.normalize();

	if ( this -> second != t.second )
	{
		return( this -> second > t.second );
	}
	else
	{
		return( this -> u_second > t.u_second );
	}
}

Time_Stamp  Time_Stamp::get_current_time()
{
	return( Time_Stamp( Time_Stamp::Current_Time ) );
}



//
// Time_Diff
//
Time_Stamp::Time_Diff::Time_Diff( int64_t  u_second )
	: u_second( u_second )
{
}

Time_Stamp::Time_Diff::Time_Diff( time_t  second ,  long  u_second )
	: u_second( static_cast<int64_t>(second) * 1000 * 1000 + u_second )
{
}


Time_Stamp::Time_Diff::~Time_Diff()
{
}


void   Time_Stamp::Time_Diff::set( time_t  second ,  long  u_second )
{
	this -> u_second = static_cast<int64_t>(second) * 1000 * 1000
			   + u_second;
}


int64_t  Time_Stamp::Time_Diff::usec() const
{
	return( this -> u_second );
}

int64_t  Time_Stamp::Time_Diff::msec() const
{
	return( this -> usec() / 1000 );
}

time_t Time_Stamp::Time_Diff::sec() const
{
	return( this -> usec() / (1000 * 1000) );
}

double  Time_Stamp::Time_Diff::sec_real() const
{
	return( static_cast<double>(u_second) / (1000.0 * 1000.0) );
}

double  Time_Stamp::Time_Diff::msec_real() const
{
	return( this -> sec_real() * 1000.0 );
}

double  Time_Stamp::Time_Diff::usec_real() const
{
	return( this -> sec_real() * (1000.0 * 1000.0) );
}

Time_Stamp::Time_Diff::operator double() const
{
	return( this -> sec_real() );
}


Time_Stamp::Time_Diff  Time_Stamp::Time_Diff::operator +
						( const Time_Diff &  t ) const
{
	return( Time_Diff( this -> u_second + t.u_second ) );
}

Time_Stamp::Time_Diff  Time_Stamp::Time_Diff::operator -
						( const Time_Diff &  t ) const
{
	return( Time_Diff( this -> u_second - t.u_second ) );
}


#if 0
Time_Stamp::Time_Diff  Time_Stamp::Time_Diff::operator - () const
{
}

Time_Stamp::Time_Diff  Time_Stamp::Time_Diff::operator * ( int  n ) const
{
}

Time_Stamp::Time_Diff  Time_Stamp::Time_Diff::operator * ( double  n ) const
{
}

Time_Stamp::Time_Diff  Time_Stamp::Time_Diff::operator / ( int  n ) const
{
}

Time_Stamp::Time_Diff  Time_Stamp::Time_Diff::operator / ( double  n ) const
{
}
#endif
