#ifndef	   SOCKCTL_OPTION_ANALYZER_H_INCLUDED
#define	   SOCKCTL_OPTION_ANALYZER_H_INCLUDED

// Author:		H. Shimora
// Created:		Nov 24 2002
// Version:		0.00

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.00  Nov 24 2002    base version.
//
//

#include  "option_analyzer.h"
#include  "ip_address.h"
#include  <string>
#include  <iostream>

class  Sockctl_Option_Analyzer : public Option_Analyzer
{
private:
	bool		help_;

	std::string	host_;
	port_number_t	port_;
	bool		ipv4_only_;

	bool		debug_;

public:
	Sockctl_Option_Analyzer( const std::string &  default_host ,
				 port_number_t  default_port )
		: help_( false ) ,
		  host_( default_host ) ,
		  port_( default_port ) ,
		  ipv4_only_( false ) ,
		  debug_( false )
	{
		add_long_option_flag_on (       "--help"  , &help_ );
		add_option_port_number  ( 'p' , "--port"  , &port_ );
		add_option_string       ( 'h' , "--host"  , &host_ );
		add_short_option_flag_on( '4'             , &ipv4_only_ );
		add_long_option_flag_on (       "--debug" , &debug_ );
	}

	virtual	~Sockctl_Option_Analyzer()
	{
	}

	virtual	bool	check() const
	{
		if ( help_ )
		{
			return( true );
		}

		return( port_ != 0 );
	}

	virtual	void	usage( std::ostream *  ostr = &std::cerr ) const
	{
		(*ostr)
		   << "Usage: "
		   << this -> program_name()
		   <<   " -p PORT [option ...]" << std::endl
		   << "Possible options are:" << std::endl
		   << "      --help"       << std::endl
		   << "  -h, --host HOST"  << std::endl
		   << "  -p, --port PORT"  << std::endl
		   << "  -4"               << std::endl
		   << "      --debug"      << std::endl;
	}

	virtual	bool	help() const
	{
		return( help_ );
	}

	virtual	std::string	host() const
	{
		return( host_ );
	}

	virtual	port_number_t	port() const
	{
		return( port_ );
	}

	virtual	bool	ipv4_only() const
	{
		return( ipv4_only_ );
	}

	virtual	bool	debug() const
	{
		return( debug_ );
	}
};


#endif	/* SOCKCTL_OPTION_ANALYZER_H_INCLUDED */
