/*
 * Decompiled with CFR 0.152.
 */
package daruma.server;

import daruma.sql.DatabaseConnectionException;
import daruma.sql.MySQLDatabaseConnectionFactory;
import daruma.storage_manager.DBMSStorageManager;
import daruma.util.EncodingConversionOutputStream;
import daruma.util.FatalException;
import daruma.util.Itk;
import daruma.util.LogWriter;
import daruma.util.TeeInputStream;
import daruma.util.TeeOutputStream;
import daruma.wfs.SOAPFaultDocumentBuilder;
import daruma.wfs.SOAPWFSProcessor;
import daruma.xml.util.XMLFormatConverter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class ConnectionHandler
implements Runnable {
    private static Object lock = new Object();
    private InputStream in;
    private OutputStream out;
    private List<OutputStream> outputStreamList = new ArrayList<OutputStream>();
    private DBMSStorageManager storage;
    private String debugTag;
    private boolean debug = false;
    private boolean ioLog = false;
    private File ioLogDirectory = null;
    private boolean compressReceiveStreamByGzip = false;
    private boolean compressSendStreamByGzip = false;
    private long connectionID = -1L;
    private static Boolean cEncodingWarned = false;

    public ConnectionHandler(InputStream in, OutputStream out, String databaseName, String user, String passwd, boolean compressReceiveStreamByGzip, boolean compressSendStreamByGzip, String debugTag, boolean debug, boolean ioLog, File ioLogDirectory, long connectionID) throws DatabaseConnectionException {
        this.in = in;
        this.out = out;
        this.outputStreamList.add(this.out);
        this.debugTag = debugTag;
        this.debug = debug;
        this.ioLog = ioLog;
        this.ioLogDirectory = ioLogDirectory;
        this.connectionID = connectionID;
        this.compressReceiveStreamByGzip = compressReceiveStreamByGzip;
        this.compressSendStreamByGzip = compressSendStreamByGzip;
        this.storage = new DBMSStorageManager(new MySQLDatabaseConnectionFactory().create());
        this.storage.connect(databaseName, user, passwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = lock;
        synchronized (object) {
            try {
                LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Open  :", this.debugTag);
                this.runImplement();
            }
            catch (Throwable throwable) {
                LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Close :", this.debugTag);
                throw throwable;
            }
            LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Close :", this.debugTag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runImplement() {
        try {
            this.in = new BufferedInputStream(this.in);
            this.out = this.get_ostream(new BufferedOutputStream(this.out));
            if (this.compressSendStreamByGzip) {
                this.out = new GZIPOutputStream(this.out);
                this.outputStreamList.add(this.out);
            }
            if (this.compressReceiveStreamByGzip) {
                this.in = new GZIPInputStream(this.in);
            }
            if (this.debug) {
                this.in = new TeeInputStream(this.in, System.out, false);
                this.out = new TeeOutputStream(this.out, System.out, false);
                this.outputStreamList.add(this.out);
            }
            if (this.ioLog) {
                String fileNameBase = "log-" + this.connectionID;
                FileOutputStream inputLogFile = new FileOutputStream(new File(this.ioLogDirectory, fileNameBase + "-from-client"));
                FileOutputStream outputLogFile = new FileOutputStream(new File(this.ioLogDirectory, fileNameBase + "-to-client"));
                this.in = new TeeInputStream(this.in, inputLogFile, false);
                this.out = new TeeOutputStream(this.out, outputLogFile, false);
                this.outputStreamList.add(this.out);
            }
            SOAPWFSProcessor p = new SOAPWFSProcessor();
            p.setDebugTag(this.debugTag);
            p.process(this.in, this.out, this.storage);
            this.storage.close();
            this.closeAllOutputStream();
            this.in.close();
        }
        catch (IOException e) {
            try {
                XMLFormatConverter.print(new SOAPFaultDocumentBuilder(e).newDocument(), this.out);
            }
            catch (ParserConfigurationException pe) {
                pe.printStackTrace();
            }
            catch (TransformerException te) {
                te.printStackTrace();
            }
        }
        catch (DatabaseConnectionException dce) {
            dce.printStackTrace();
        }
        catch (FatalException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.closeAllOutputStream();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void closeAllOutputStream() throws IOException {
        int i;
        for (i = this.outputStreamList.size() - 1; i >= 0; --i) {
            OutputStream ostr = this.outputStreamList.get(i);
            ostr.flush();
            if (!(ostr instanceof GZIPOutputStream)) continue;
            ((GZIPOutputStream)ostr).finish();
        }
        for (i = this.outputStreamList.size() - 1; i >= 0; --i) {
            this.outputStreamList.get(i).close();
        }
    }

    private OutputStream get_ostream(OutputStream raw) {
        OutputStream enc;
        String encoding = System.getProperty("file.encoding");
        if (!encoding.equalsIgnoreCase("utf-8") && !encoding.equalsIgnoreCase("utf8")) {
            if (!cEncodingWarned.booleanValue()) {
                LogWriter.qwrite("WARN", "I/O encoding is not UTF-8. Applies trivial encoding conversion.");
                cEncodingWarned = true;
            }
            try {
                enc = new EncodingConversionOutputStream(raw, "utf-8");
                this.outputStreamList.add(enc);
            }
            catch (UnsupportedEncodingException uee) {
                LogWriter.qwrite("FATAL", "Encoding name error. Message: ", uee.getMessage());
                Object enc2 = null;
                throw new RuntimeException();
            }
        } else {
            enc = raw;
        }
        return enc;
    }
}

