/*
 * Decompiled with CFR 0.152.
 */
package daruma.wfs.filter.predicates;

import daruma.geometry.TransformationContext;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.wfs.filter.PredicateDescription;
import daruma.wfs.filter.predicates.GeometryPredicateDescription;
import daruma.wfs.filter.predicates.ImmidiateValueBooleanDescription;
import daruma.wfs.filter.predicates.LogicalPredicateDescription;
import daruma.wfs.filter.predicates.PropertyComparationPredicateDescription;
import daruma.xml.util.XMLParseErrorException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IntegratedPredicateDescription
extends PredicateDescription {
    private String sqlExpression;

    public static boolean isAcceptablePredicate(String localName) {
        return PropertyComparationPredicateDescription.isAcceptablePredicate(localName) || GeometryPredicateDescription.isAcceptablePredicate(localName) || ImmidiateValueBooleanDescription.isAcceptablePredicate(localName) || LogicalPredicateDescription.isAcceptablePredicate(localName);
    }

    public IntegratedPredicateDescription(Element element, TypeDefinition type, TransformationContext trans, StorageManager storage) throws XMLParseErrorException {
        super(storage, type, trans);
        this.sqlExpression = this.createSQLExpression(element);
    }

    @Override
    public String getSQLExpression() {
        return this.sqlExpression;
    }

    public String createSQLExpression(Element element) throws XMLParseErrorException {
        String localName = element.getLocalName();
        PredicateDescription child = null;
        if (PropertyComparationPredicateDescription.isAcceptablePredicate(localName)) {
            child = new PropertyComparationPredicateDescription(element, super.getTypeDefinition(), super.getTransformationContext(), super.getStorage());
        } else if (GeometryPredicateDescription.isAcceptablePredicate(localName)) {
            child = new GeometryPredicateDescription(element, super.getTypeDefinition(), super.getTransformationContext(), super.getStorage());
        } else if (ImmidiateValueBooleanDescription.isAcceptablePredicate(localName)) {
            child = new ImmidiateValueBooleanDescription(element, super.getTypeDefinition(), super.getTransformationContext(), super.getStorage());
        } else if (LogicalPredicateDescription.isAcceptablePredicate(localName)) {
            child = new LogicalPredicateDescription(element, super.getTypeDefinition(), super.getTransformationContext(), super.getStorage());
        } else {
            throw new XMLParseErrorException("cannot handle filter \"" + localName + "\"");
        }
        this.addChild(child);
        return child.getSQLExpression();
    }

    @Override
    public boolean detailedCheck(Node feature) throws XMLParseErrorException {
        if (this.numberOfChildren() > 0) {
            return this.getChild(0).detailedCheck(feature);
        }
        return true;
    }
}

