package daruma.global_switch;

import daruma.util.PropertyReader;

public class ImplementationSwitches
{
    private static final String ENABLE_GEOMETRY_CONVERSION_PROPERTY
				= "daruma.geometry.enable_conversion";
    private static final boolean ENABLE_GEOMETRY_CONVERSION_PROPERTY_DEFAULT
				 = true;

    private boolean enableGeometryConversion;

    public ImplementationSwitches()
    {
	this.enableGeometryConversion
	    = PropertyReader.getProperty
	      ( ENABLE_GEOMETRY_CONVERSION_PROPERTY,
		ENABLE_GEOMETRY_CONVERSION_PROPERTY_DEFAULT );
    }

    public boolean getEnableGeometryConversion()
    {
	return enableGeometryConversion;
    }


    //
    // singleton
    //
    private static ImplementationSwitches obj = null;

    public static ImplementationSwitches instance()
    {
	if ( obj == null )
	{
	    obj = new ImplementationSwitches();
	}

	return obj;
    }
}
