/*
 * Decompiled with CFR 0.152.
 */
package aist.daruma.client.darumaearth;

import aist.daruma.client.darumaearth.DarumaEarthConfig;
import aist.daruma.client.darumaearth.KMLConverter;
import aist.daruma.client.darumaearth.MispRequestBuilder;
import aist.daruma.client.darumaearth.MispSOAPClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class DarumaEarth {
    private DarumaEarthConfig conf = DarumaEarthConfig.getConfig();
    private String kmlOutDirName;
    private File kmlOutFile;

    public void execute(String[] args) throws Exception {
        if (this.conf.applyCommandLine(args)) {
            if (this.conf.debug()) {
                System.out.println("darumaServer = " + this.conf.darumaHost() + ":" + this.conf.darumaPort());
            }
            this.preExec();
            int execCount = 0;
            while (true) {
                this.executeOnce();
                if (this.conf.loopN() > 0 && ++execCount >= this.conf.loopN()) break;
                if (this.conf.debug()) {
                    System.out.print("(Sleeping ");
                    System.out.print(this.conf.interval());
                    System.out.print(" seconds...");
                }
                this.sleep(this.conf.interval() * 1000);
                if (!this.conf.debug()) continue;
                System.out.println("Wake Up.)");
            }
            this.postExec();
        } else {
            System.exit(-1);
        }
        if (this.conf.debug()) {
            System.out.println("");
            System.out.println("done.");
        }
    }

    private synchronized void sleep(int timeout) {
        try {
            this.wait(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void executeOnce() throws Exception {
        String resFileName;
        String reqFileName;
        try {
            File workDir = new File(this.conf.workDir());
            File reqFile = File.createTempFile("request", ".xml", workDir);
            reqFile.deleteOnExit();
            reqFileName = reqFile.getCanonicalPath();
            File resFile = File.createTempFile("response", ".xml", workDir);
            resFile.deleteOnExit();
            resFileName = resFile.getCanonicalPath();
        }
        catch (Exception e) {
            System.out.print("Error on making temporary files...");
            System.out.println(e.getMessage());
            throw e;
        }
        MispRequestBuilder reqBuilder = new MispRequestBuilder();
        try {
            reqBuilder.genGetFeatureRequestToFile(reqFileName, this.conf.primaryFeature(), this.conf.prefixNs(), this.conf.prefixUri());
            MispSOAPClient client = new MispSOAPClient();
            FileInputStream request = new FileInputStream(reqFileName);
            FileOutputStream response = new FileOutputStream(resFileName);
            client.sendRequest(this.conf.darumaHost(), this.conf.darumaPort(), request, response);
            response.close();
        }
        catch (Exception e) {
            System.out.print("Error on misp request to DaRuMa server...");
            System.out.println(e.getMessage());
            throw e;
        }
        try {
            FileInputStream response_src = new FileInputStream(resFileName);
            KMLConverter converter = new KMLConverter(reqBuilder);
            File kmlOutDir = new File(this.conf.kmlOutputDir());
            File kmlOutTempFile = File.createTempFile("kmltmp", ".kml", kmlOutDir);
            kmlOutTempFile.deleteOnExit();
            FileOutputStream kmlout = new FileOutputStream(kmlOutTempFile.getCanonicalPath());
            converter.convert(this.conf.primaryFeature(), this.conf.locationXPath(), response_src, kmlout);
            kmlout.close();
            this.kmlOutFile.delete();
            kmlOutTempFile.renameTo(this.kmlOutFile);
        }
        catch (Exception e) {
            System.out.print("Error on converting to kml file...");
            System.out.println(e.getMessage());
            throw e;
        }
    }

    private void makeLinkKmlFile() throws FileNotFoundException, IOException {
        String kmlOutFileName = this.kmlOutFile.getCanonicalPath();
        String kmlLinkFileName = this.kmlOutDirName + this.conf.kmlLinkFile();
        FileOutputStream kmlLinkFileStream = new FileOutputStream(kmlLinkFileName);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)kmlLinkFileStream, "UTF8");
        int interval = this.conf.interval();
        out.write("<kml xmlns='http://earth.google.com/kml/2.1'>");
        out.write("\n");
        out.write("  <NetworkLink>\n");
        out.write("    <name></name>\n");
        out.write("    <Link>\n");
        out.write("      <href>");
        out.write(kmlOutFileName);
        out.write("</href>\n");
        out.write("      <refreshMode>onInterval</refreshMode>\n");
        out.write("      <refreshInterval>");
        out.write(Integer.toString(interval));
        out.write("</refreshInterval>\n");
        out.write("    </Link>\n");
        out.write("  </NetworkLink>\n");
        out.write("</kml>\n");
        out.close();
        kmlLinkFileStream.close();
    }

    private void preExec() throws Exception {
        File workDir = new File(this.conf.workDir());
        workDir.mkdirs();
        workDir.deleteOnExit();
        File kmlOutputDir = new File(this.conf.kmlOutputDir());
        kmlOutputDir.mkdirs();
        this.kmlOutDirName = this.conf.kmlOutputDir();
        if (!this.kmlOutDirName.endsWith(File.separator)) {
            this.kmlOutDirName = this.kmlOutDirName + File.separator;
        }
        String kmlOutFileName = this.kmlOutDirName + this.conf.kmlDocFile();
        this.kmlOutFile = new File(kmlOutFileName);
        try {
            this.makeLinkKmlFile();
        }
        catch (Exception e) {
            System.out.print("Error on make link.kml file. ");
            System.out.println(e.getMessage());
            throw e;
        }
    }

    private void postExec() {
        this.kmlOutFile = null;
    }

    public static void main(String[] args) {
        DarumaEarth darumaEarth = new DarumaEarth();
        try {
            darumaEarth.execute(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

