/*
 * Decompiled with CFR 0.152.
 */
package aist.daruma.client.darumaearth;

import aist.daruma.client.darumaearth.DarumaEarthConfigException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class DarumaEarthConfig {
    private static final String DEFAULT_PROPERTIES_FILENAME = "etc/defaultDarumaEarth.properties";
    private static final String CONFIGLINE_REGEX_PATTERN = "^-{1,2}(\\w+)=([\\S]+)\\s*";
    private static final String CONFIGLINE_REGEX_PATTERN_NOVALUE = "^-{1,2}(\\w+)$";
    private static final String CONFIGKEY_DEBUG = "debug";
    private static final String CONFIGKEY_DARUMA_HOST = "host";
    private static final String CONFIGKEY_DARUMA_PORT = "port";
    private static final String CONFIGKEY_VALUE_MAXLEN = "valueMaxLen";
    private static final String CONFIGKEY_INTERVAL = "interval";
    private static final String CONFIGKEY_LOOPN = "loopN";
    private static final String CONFIGKEY_PREFIX = "prefix";
    private static final String CONFIGKEY_DEFAULTNAME = "defaultName";
    private static final String CONFIGKEY_PRIMARYFEATURE = "primaryFeature";
    private static final String CONFIGKEY_LOCATION_XPATH = "locationXPath";
    private static final String CONFIGKEY_ID_XPATH = "idXPath";
    private static final String CONFIGKEY_DATAREF_XPATH = "dataRefXPath";
    private static final String CONFIGKEY_DATA_FEATURE = "dataFeature";
    private static final String CONFIGKEY_DATAID_XPATH = "dataIdXPath";
    private static final String CONFIGKEY_DATA_XPATH = "dataXPath";
    private static final String CONFIGKEY_ENCODE_XPATH = "encodeXPath";
    private static final String CONFIGKEY_TIMESTAMP_XPATH = "timestampXPath";
    private static final String CONFIGKEY_TIMESTAMP = "timestamp";
    private static final String CONFIGKEY_LINKNAME = "linkName";
    private static final String CONFIGKEY_KML_OUTPUTDIR = "kmlOutputDir";
    private static final String CONFIGKEY_KML_DOCFILE = "kmlDocFile";
    private static final String CONFIGKEY_KML_LINKFILE = "kmlLinkFile";
    private static final String CONFIGKEY_IMAGEDIR = "imageDir";
    private static final String CONFIGKEY_WORKDIR = "workDir";
    private static final String CONFIGKEY_OFFSET_X = "offsetX";
    private static final String CONFIGKEY_OFFSET_Y = "offsetY";
    private static final String CONFIGKEY_OFFSET_Z = "offsetZ";
    private static final String CONFIGKEY_SCALE_X = "scaleX";
    private static final String CONFIGKEY_SCALE_Y = "scaleY";
    private static final String CONFIGKEY_FLIP_XY = "flipXY";
    private static final String CONFIGKEY_STYLE_URL = "styleURL";
    private static final String CONFIGKEY_ICON_COLOR = "iconColor";
    private static final String CONFIGKEY_ICON_SCALE = "iconScale";
    private static final String CONFIGKEY_ICON_HREF = "iconHref";
    private static final String CONFIGKEY_ICON_METRIC = "iconMetric";
    private static final String CONFIGKEY_LABEL_COLOR = "labelColor";
    private static final String CONFIGKEY_LABEL_SCALE = "labelScale";
    private static final String CONFIGKEY_LINE_COLOR = "lineColor";
    private static final String CONFIGKEY_LINE_WIDTH = "lineWidth";
    private static final String CONFIGKEY_HELPMESSAGE = "help.message";
    private static DarumaEarthConfig confInstance = new DarumaEarthConfig();
    private static Configuration config;
    boolean debug_ = false;
    private String prefixNsStr = null;
    private String prefixUriStr = "";
    private int iconX;
    private int iconY;
    private int iconW;
    private int iconH;
    private Options options_;

    public static DarumaEarthConfig getConfig() {
        return confInstance;
    }

    public boolean debug() {
        return this.debug_;
    }

    public String darumaHost() {
        return config.getString(CONFIGKEY_DARUMA_HOST);
    }

    public int darumaPort() {
        return config.getInt(CONFIGKEY_DARUMA_PORT);
    }

    public int valueMaxLen() {
        return config.getInt(CONFIGKEY_VALUE_MAXLEN);
    }

    public int interval() {
        return config.getInt(CONFIGKEY_INTERVAL);
    }

    public int loopN() {
        return config.getInt(CONFIGKEY_LOOPN);
    }

    private String prefix() {
        return config.getString(CONFIGKEY_PREFIX);
    }

    private void setPrefix() {
        String prefixStr = this.prefix();
        if (prefixStr == null || prefixStr.equals("")) {
            this.prefixNsStr = null;
            this.prefixUriStr = "";
        } else if (prefixStr.contains("=")) {
            if (prefixStr.startsWith("=")) {
                this.prefixNsStr = null;
                this.prefixUriStr = prefixStr.substring(1);
            } else {
                String[] nsUri = prefixStr.split("=");
                this.prefixNsStr = nsUri[0];
                this.prefixUriStr = nsUri[1];
            }
        }
    }

    public String prefixNs() {
        return this.prefixNsStr;
    }

    public String prefixUri() {
        return this.prefixUriStr;
    }

    public String defaultName() {
        return config.getString(CONFIGKEY_DEFAULTNAME);
    }

    public String primaryFeature() {
        return config.getString(CONFIGKEY_PRIMARYFEATURE);
    }

    public String locationXPath() {
        return config.getString(CONFIGKEY_LOCATION_XPATH);
    }

    public String idXPath() {
        return config.getString(CONFIGKEY_ID_XPATH);
    }

    public String dataRefXPath() {
        return config.getString(CONFIGKEY_DATAREF_XPATH);
    }

    public String dataFeature() {
        return config.getString(CONFIGKEY_DATA_FEATURE);
    }

    public String dataIdXPath() {
        return config.getString(CONFIGKEY_DATAID_XPATH);
    }

    public String dataXPath() {
        return config.getString(CONFIGKEY_DATA_XPATH);
    }

    public String encodeXPath() {
        return config.getString(CONFIGKEY_ENCODE_XPATH);
    }

    public String timestampXPath() {
        return config.getString(CONFIGKEY_TIMESTAMP_XPATH);
    }

    public boolean timestamp() {
        return config.getBoolean(CONFIGKEY_TIMESTAMP);
    }

    public String linkName() {
        return config.getString(CONFIGKEY_LINKNAME);
    }

    public String kmlOutputDir() {
        return config.getString(CONFIGKEY_KML_OUTPUTDIR);
    }

    public String kmlDocFile() {
        return config.getString(CONFIGKEY_KML_DOCFILE);
    }

    public String kmlLinkFile() {
        return config.getString(CONFIGKEY_KML_LINKFILE);
    }

    public String imageDir() {
        return config.getString(CONFIGKEY_IMAGEDIR);
    }

    public String workDir() {
        return config.getString(CONFIGKEY_WORKDIR);
    }

    public double offsetX() {
        return config.getDouble(CONFIGKEY_OFFSET_X);
    }

    public double offsetY() {
        return config.getDouble(CONFIGKEY_OFFSET_Y);
    }

    public double offsetZ() {
        return config.getDouble(CONFIGKEY_OFFSET_Z);
    }

    public double scaleX() {
        return config.getDouble(CONFIGKEY_SCALE_X);
    }

    public double scaleY() {
        return config.getDouble(CONFIGKEY_SCALE_Y);
    }

    public boolean flipXY() {
        return config.getBoolean(CONFIGKEY_FLIP_XY);
    }

    public String styleURL() {
        return config.getString(CONFIGKEY_STYLE_URL);
    }

    public String iconColor() {
        return config.getString(CONFIGKEY_ICON_COLOR);
    }

    public double iconScale() {
        return config.getDouble(CONFIGKEY_ICON_SCALE);
    }

    public String iconHref() {
        return config.getString(CONFIGKEY_ICON_HREF);
    }

    public int iconX() {
        return this.iconX;
    }

    public int iconY() {
        return this.iconY;
    }

    public int iconW() {
        return this.iconW;
    }

    public int iconH() {
        return this.iconH;
    }

    private void setIconMetric() {
        String metricStr = config.getString(CONFIGKEY_ICON_METRIC);
        String[] metrics = metricStr.split(":");
        this.iconX = Integer.parseInt(metrics[0]);
        this.iconY = Integer.parseInt(metrics[1]);
        if (metrics.length > 2) {
            this.iconW = Integer.parseInt(metrics[2]);
            this.iconH = Integer.parseInt(metrics[3]);
        }
    }

    public String labelColor() {
        return config.getString(CONFIGKEY_LABEL_COLOR);
    }

    public double labelScale() {
        return config.getDouble(CONFIGKEY_LABEL_SCALE);
    }

    public String lineColor() {
        return config.getString(CONFIGKEY_LINE_COLOR);
    }

    public int lineWidth() {
        return config.getInt(CONFIGKEY_LINE_WIDTH);
    }

    private DarumaEarthConfig() {
        config = this.loadDefaultConfig();
        this.setupOptions();
    }

    public boolean applyCommandLine(String[] args) {
        CommandLine cmd = this.parseCommandLine(args);
        Configuration defConfig = config;
        if (cmd != null) {
            if (cmd.hasOption("conf")) {
                String confFileName = cmd.getOptionValue("conf");
                try {
                    this.applyConfFile(confFileName, defConfig);
                }
                catch (FileNotFoundException fnex) {
                    System.out.print("Error on reading configuration file ");
                    System.out.println(fnex.getMessage());
                    return false;
                }
                catch (IOException ioex) {
                    System.out.print("Read error occured when reading config file ");
                    System.out.print(confFileName);
                    System.out.println(".");
                    System.out.println(ioex.getMessage());
                    return false;
                }
                catch (DarumaEarthConfigException dex) {
                    System.out.print("Config file error occured ");
                    System.out.print(confFileName);
                    System.out.println(".");
                    System.out.println(dex.getMessage());
                    return false;
                }
            }
            Iterator keyIter = defConfig.getKeys();
            PropertiesConfiguration tmpConfig = new PropertiesConfiguration();
            while (keyIter.hasNext()) {
                String key = (String)keyIter.next();
                if (cmd.hasOption(key)) {
                    if (this.IsOptionBoolean(key)) {
                        tmpConfig.setProperty(key, (Object)true);
                        continue;
                    }
                    tmpConfig.setProperty(key, (Object)cmd.getOptionValue(key));
                    continue;
                }
                tmpConfig.setProperty(key, defConfig.getProperty(key));
            }
            defConfig = tmpConfig;
            if (cmd.hasOption(CONFIGKEY_PREFIX)) {
                String prefix = cmd.getOptionValue(CONFIGKEY_PREFIX);
                defConfig.setProperty(CONFIGKEY_PREFIX, (Object)prefix);
            }
            if (cmd.hasOption(CONFIGKEY_DEBUG)) {
                this.debug_ = true;
                System.out.println("debug enabled");
            }
            config = defConfig;
            this.setPrefix();
            this.setIconMetric();
            return true;
        }
        return false;
    }

    private Configuration loadDefaultConfig() {
        String configFileName = DEFAULT_PROPERTIES_FILENAME;
        PropertiesConfiguration defConfig = null;
        try {
            PropertiesConfiguration absConfig = defConfig = new PropertiesConfiguration(configFileName);
            absConfig.setThrowExceptionOnMissing(true);
            String strVal = null;
            int intVal = 0;
            double dblVal = 0.0;
            boolean boolVal = false;
            strVal = defConfig.getString(CONFIGKEY_DARUMA_HOST);
            intVal = defConfig.getInt(CONFIGKEY_DARUMA_PORT);
            intVal = defConfig.getInt(CONFIGKEY_VALUE_MAXLEN);
            intVal = defConfig.getInt(CONFIGKEY_INTERVAL);
            intVal = defConfig.getInt(CONFIGKEY_LOOPN);
            try {
                strVal = defConfig.getString(CONFIGKEY_PREFIX);
            }
            catch (NoSuchElementException nse) {
                // empty catch block
            }
            strVal = defConfig.getString(CONFIGKEY_DEFAULTNAME);
            strVal = defConfig.getString(CONFIGKEY_PRIMARYFEATURE);
            strVal = defConfig.getString(CONFIGKEY_LOCATION_XPATH);
            strVal = defConfig.getString(CONFIGKEY_ID_XPATH);
            strVal = defConfig.getString(CONFIGKEY_DATAREF_XPATH);
            strVal = defConfig.getString(CONFIGKEY_DATA_FEATURE);
            strVal = defConfig.getString(CONFIGKEY_DATAID_XPATH);
            strVal = defConfig.getString(CONFIGKEY_DATA_XPATH);
            strVal = defConfig.getString(CONFIGKEY_ENCODE_XPATH);
            strVal = defConfig.getString(CONFIGKEY_TIMESTAMP_XPATH);
            boolVal = defConfig.getBoolean(CONFIGKEY_TIMESTAMP);
            strVal = defConfig.getString(CONFIGKEY_LINKNAME);
            strVal = defConfig.getString(CONFIGKEY_KML_OUTPUTDIR);
            strVal = defConfig.getString(CONFIGKEY_KML_DOCFILE);
            strVal = defConfig.getString(CONFIGKEY_KML_LINKFILE);
            strVal = defConfig.getString(CONFIGKEY_IMAGEDIR);
            strVal = defConfig.getString(CONFIGKEY_WORKDIR);
            dblVal = defConfig.getDouble(CONFIGKEY_OFFSET_X);
            dblVal = defConfig.getDouble(CONFIGKEY_OFFSET_Y);
            dblVal = defConfig.getDouble(CONFIGKEY_OFFSET_Z);
            dblVal = defConfig.getDouble(CONFIGKEY_SCALE_X);
            dblVal = defConfig.getDouble(CONFIGKEY_SCALE_Y);
            boolVal = defConfig.getBoolean(CONFIGKEY_FLIP_XY);
            strVal = defConfig.getString(CONFIGKEY_STYLE_URL);
            strVal = defConfig.getString(CONFIGKEY_ICON_COLOR);
            dblVal = defConfig.getDouble(CONFIGKEY_ICON_SCALE);
            strVal = defConfig.getString(CONFIGKEY_ICON_HREF);
            strVal = defConfig.getString(CONFIGKEY_ICON_METRIC);
            strVal = defConfig.getString(CONFIGKEY_LABEL_COLOR);
            dblVal = defConfig.getDouble(CONFIGKEY_LABEL_SCALE);
            strVal = defConfig.getString(CONFIGKEY_LINE_COLOR);
            intVal = defConfig.getInt(CONFIGKEY_LINE_WIDTH);
            absConfig.setThrowExceptionOnMissing(false);
        }
        catch (NoSuchElementException nse) {
            System.out.print("Error on default configuration file ");
            System.out.print(configFileName);
            System.out.print(":");
            System.out.println(nse.getMessage());
            System.exit(-1);
        }
        catch (ConfigurationException ce) {
            System.out.print("Error on reading ");
            System.out.print(configFileName);
            System.out.print(":");
            System.out.println(ce.getMessage());
            System.exit(-1);
        }
        return defConfig;
    }

    private boolean IsOptionBoolean(String key) {
        boolean result = false;
        String prop = config.getString(key + ".isboolean");
        if (prop != null && (prop.equals("yes") || prop.equals("true"))) {
            result = true;
        }
        return result;
    }

    private String getOptionArgName(String key) {
        String argName = config.getString(key + ".argname");
        if (argName == null) {
            argName = key;
        }
        return argName;
    }

    private String getOptionDescription(String key, String val) {
        String description = config.getString(key + ".description");
        description = description == null ? " : (" + val + ")" : " : " + description;
        return description;
    }

    private void setupOptions() {
        Options options = new Options();
        Iterator keyIter = config.getKeys();
        while (keyIter.hasNext()) {
            Option opt;
            String key = (String)keyIter.next();
            String val = config.getString(key);
            if (key.contains(".")) continue;
            String description = this.getOptionDescription(key, val);
            if (this.IsOptionBoolean(key)) {
                OptionBuilder.withDescription((String)description);
                opt = OptionBuilder.create((String)key);
            } else {
                String argName = this.getOptionArgName(key);
                OptionBuilder.hasArg();
                OptionBuilder.withArgName((String)argName);
                OptionBuilder.withDescription((String)description);
                opt = OptionBuilder.create((String)key);
            }
            options.addOption(opt);
        }
        OptionBuilder.withDescription((String)"for verbose output");
        Option optDebug = OptionBuilder.create((String)CONFIGKEY_DEBUG);
        options.addOption(optDebug);
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)"filename");
        OptionBuilder.withDescription((String)" : config file");
        Option optConf = OptionBuilder.create((String)"conf");
        options.addOption(optConf);
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)this.getOptionArgName(CONFIGKEY_PREFIX));
        OptionBuilder.withDescription((String)this.getOptionDescription(CONFIGKEY_PREFIX, null));
        Option optPrefix = OptionBuilder.create((String)CONFIGKEY_PREFIX);
        options.addOption(optPrefix);
        this.options_ = options;
    }

    public void printUsage() {
        String helpMessage = config.getString(CONFIGKEY_HELPMESSAGE);
        if (helpMessage != null) {
            System.out.println(helpMessage);
        } else {
            HelpFormatter help = new HelpFormatter();
            help.printHelp("DarumaEarth -conf <configfile> [<options>...]", "Options:", this.options_, "", false);
        }
    }

    private CommandLine parseCommandLine(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(this.options_, args);
            if (cmd != null && cmd.getOptions().length == 0) {
                this.printUsage();
                cmd = null;
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            this.printUsage();
        }
        return cmd;
    }

    private void applyConfFile(String confFileName, Configuration conf) throws FileNotFoundException, IOException, DarumaEarthConfigException {
        String lineStr;
        FileReader reader = new FileReader(confFileName);
        LineNumberReader lnReader = new LineNumberReader(reader);
        Pattern confPattern = Pattern.compile(CONFIGLINE_REGEX_PATTERN);
        Pattern confPatternNoValue = Pattern.compile(CONFIGLINE_REGEX_PATTERN_NOVALUE);
        while ((lineStr = lnReader.readLine()) != null) {
            String key;
            if (lineStr.equals("") || lineStr.startsWith("#")) continue;
            int lineNum = lnReader.getLineNumber();
            Matcher matcher = confPattern.matcher(lineStr);
            Matcher matcherNoValue = confPatternNoValue.matcher(lineStr);
            boolean error = false;
            if (matcher.matches() && matcher.groupCount() >= 2) {
                key = matcher.group(1);
                String value = matcher.group(2);
                if (conf.containsKey(key) || key.equals(CONFIGKEY_PREFIX)) {
                    conf.setProperty(key, (Object)value);
                    if (key.equals(CONFIGKEY_ICON_METRIC)) {
                        this.setIconMetric();
                    }
                } else {
                    error = true;
                }
            } else if (matcherNoValue.matches()) {
                key = matcherNoValue.group(1);
                if (conf.containsKey(key)) {
                    if (this.IsOptionBoolean(key)) {
                        conf.setProperty(key, (Object)true);
                    } else {
                        error = true;
                    }
                } else {
                    error = true;
                }
            }
            if (!error) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("Illeagal configuration at");
            sb.append(lineNum);
            sb.append(" : ");
            sb.append(lineStr);
            throw new DarumaEarthConfigException(sb.toString());
        }
    }
}

