/*
 * Decompiled with CFR 0.152.
 */
package aist.daruma.client.darumaearth;

import aist.daruma.client.darumaearth.GmlLineString;
import aist.daruma.client.darumaearth.GmlLinearRing;
import aist.daruma.client.darumaearth.GmlPoint;
import aist.daruma.client.darumaearth.GmlPolygon;
import aist.daruma.client.darumaearth.ScanGmlException;
import aist.daruma.client.darumaearth.XmlUtil;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Node;

public class GmlGeometry {
    protected static final String tagPrefix = "gml";
    protected static final String tagName = "Geometry";
    protected static final String tagFullName = "gml:Geometry";
    protected static final String coordNodeXPath = "gml:coordinates/text()";
    protected static final String exteriorNodeXPath = "gml:exterior";
    protected static final String outerBoundaryIsNodeXPath = "gml:outerBoundaryIs";
    protected static final String interiorNodeXPath = "gml:interior";
    protected static final String innerBoundaryIsNodeXPath = "gml:innerBoundaryIs";

    public String gmlTagPrefix() {
        return tagPrefix;
    }

    public String gmlTagName() {
        return tagName;
    }

    public String gmlTagFullName() {
        return this.gmlTagPrefix() + ":" + this.gmlTagName();
    }

    public static GmlGeometry scanGml(Node xmlNode, NamespaceContext nsContext, Object crs) throws ScanGmlException, Exception {
        String tagName;
        String crsStr = XmlUtil.getAttributeByName(xmlNode, "srsName");
        if (crsStr == null || crsStr.equals("")) {
            // empty if block
        }
        if ((tagName = xmlNode.getLocalName()).equals("Point")) {
            return GmlPoint.scanGmlBody(xmlNode, nsContext, crs);
        }
        if (tagName.equals("LineString")) {
            return GmlLineString.scanGmlBody(xmlNode, nsContext, crs);
        }
        if (tagName.equals("LinearRing")) {
            return GmlLinearRing.scanGmlBody(xmlNode, nsContext, crs);
        }
        if (tagName.equals("Polygon")) {
            return GmlPolygon.scanGmlBody(xmlNode, nsContext, crs);
        }
        System.out.println("GmlGeometry#scanGml: Unsupported node \"" + tagName + "\" encounterd.");
        return null;
    }
}

