/*
 * Decompiled with CFR 0.152.
 */
package aist.daruma.client.darumaearth;

import aist.daruma.client.darumaearth.GmlGeometry;
import aist.daruma.client.darumaearth.GmlUtil;
import aist.daruma.client.darumaearth.ScanGmlException;
import aist.daruma.client.darumaearth.XmlUtil;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Node;

public class GmlPoint
extends GmlGeometry {
    protected static final String tagName = "Point";
    private double x;
    private double y;
    private double z;
    private boolean hasZ = false;

    public String gmlTagName() {
        return tagName;
    }

    public GmlPoint() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = Double.NaN;
        this.hasZ = false;
    }

    public GmlPoint(double x, double y) {
        this.setXY(x, y);
    }

    public GmlPoint(double x, double y, double z) {
        this.setXY(x, y);
        this.setZ(z);
    }

    public GmlPoint(GmlPoint point) {
        this.setXY(point.x, point.y);
        if (point.hasZ()) {
            this.setZ(point.z);
        }
    }

    public boolean hasZ() {
        return this.hasZ;
    }

    public void setXY(double x, double y) {
        this.x = x;
        this.y = y;
        this.z = 0.0;
        this.hasZ = false;
    }

    public void setXYZ(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.hasZ = true;
    }

    public void setZ(double z) {
        this.z = z;
        this.hasZ = true;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public static GmlPoint scanGmlBody(Node xmlNode, NamespaceContext nsContext, Object crs) throws ScanGmlException, Exception {
        Node coordNode = XmlUtil.getNodeByXPath(xmlNode, "gml:coordinates/text()", nsContext);
        if (coordNode == null) {
            throw new ScanGmlException("gml:coordinates/text() not matched.");
        }
        String gmlCoordStr = coordNode.getNodeValue();
        return GmlPoint.newPointForCoordinatesWithCRS(gmlCoordStr, crs);
    }

    public static GmlPoint newPointForCoordinatesWithCRS(String gmlCoordStr, Object crs) {
        String[] coordValues = gmlCoordStr.split(",");
        double[] pointValues = GmlUtil.gmlCoodStrToSysValueWithCRS(gmlCoordStr, crs);
        double x = pointValues[0];
        double y = pointValues[1];
        if (coordValues.length > 2) {
            double z = Double.parseDouble(coordValues[2]);
            return new GmlPoint(x, y, z);
        }
        return new GmlPoint(x, y);
    }
}

