/*
 * Decompiled with CFR 0.152.
 */
package aist.daruma.client.darumaearth;

import aist.daruma.client.darumaearth.GmlCurve;
import aist.daruma.client.darumaearth.GmlGeometry;
import aist.daruma.client.darumaearth.ScanGmlException;
import aist.daruma.client.darumaearth.XmlUtil;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GmlSurface
extends GmlGeometry {
    protected static final String tagName = "Surface";
    protected GmlCurve exterior = new GmlCurve();
    protected ArrayList<GmlCurve> interior = new ArrayList();

    @Override
    public String gmlTagName() {
        return tagName;
    }

    public GmlSurface() {
    }

    public GmlSurface(GmlCurve exterior, ArrayList<GmlCurve> interior) {
        this.setGeometryList(exterior, interior);
    }

    public void setGeometryList(GmlCurve exterior, ArrayList<GmlCurve> interior) {
        this.clear();
        this.exterior = exterior;
        this.interior.addAll(interior);
    }

    public void clear() {
        this.exterior = null;
        this.interior.clear();
    }

    public void setExterior(GmlCurve exterior) {
        this.exterior = exterior;
    }

    public GmlCurve getExterior() {
        return this.exterior;
    }

    public void addInterior(GmlCurve geom) {
        this.interior.add(geom);
    }

    public void addInterior(ArrayList<GmlCurve> interior) {
        this.interior.addAll(interior);
    }

    public GmlGeometry getInteriorAt(int index) {
        return this.interior.get(index);
    }

    public int getInteriorSize() {
        return this.interior.size();
    }

    public Iterator getInteriorIterator() {
        return this.interior.iterator();
    }

    public static GmlSurface scanGmlBody(Node xmlNode, NamespaceContext nsContext, Object CRS) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void scanGmlBodyAndAddContents(Node xmlNode, NamespaceContext nsContext, Object CRS) throws ScanGmlException, Exception {
        Node n;
        int i;
        this.clear();
        Node exteriorNode = null;
        exteriorNode = XmlUtil.getNodeByXPath(xmlNode, "gml:exterior", nsContext);
        if (exteriorNode == null) {
            exteriorNode = XmlUtil.getNodeByXPath(xmlNode, "gml:outerBoundaryIs", nsContext);
        }
        if (exteriorNode == null) {
            throw new ScanGmlException("No Exterior Node.");
        }
        Node extGeoNode = XmlUtil.getNodeByXPath(exteriorNode, "*", nsContext);
        this.setExterior((GmlCurve)GmlGeometry.scanGml(extGeoNode, nsContext, CRS));
        NodeList intNodeList = null;
        intNodeList = XmlUtil.getNodeListByXPath(xmlNode, "gml:interior", nsContext);
        if (intNodeList != null) {
            for (i = 0; i < intNodeList.getLength(); ++i) {
                n = intNodeList.item(i);
                if (n.getNodeType() != 1) continue;
                this.addInterior((GmlCurve)GmlGeometry.scanGml(n, nsContext, CRS));
            }
        }
        if ((intNodeList = XmlUtil.getNodeListByXPath(xmlNode, "gml:innerBoundaryIs", nsContext)) != null) {
            for (i = 0; i < intNodeList.getLength(); ++i) {
                n = intNodeList.item(i);
                if (n.getNodeType() != 1) continue;
                this.addInterior((GmlCurve)GmlGeometry.scanGml(n, nsContext, CRS));
            }
        }
    }
}

