/*
 * Decompiled with CFR 0.152.
 */
package daruma.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TeeOutputStream
extends FilterOutputStream {
    private OutputStream teeout;
    private boolean closeTee = true;

    public TeeOutputStream(OutputStream ostream, OutputStream tee) {
        super(ostream);
        this.teeout = tee;
    }

    public TeeOutputStream(OutputStream ostream, OutputStream tee, boolean closeTeeFlag) {
        super(ostream);
        this.teeout = tee;
        this.closeTee = closeTeeFlag;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        if (this.teeout != null) {
            this.teeout.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        if (this.teeout != null) {
            this.teeout.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        if (this.teeout != null) {
            this.teeout.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
        if (this.teeout != null) {
            this.teeout.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        if (this.teeout != null && this.closeTee) {
            this.teeout.close();
        }
    }
}

