/*
 * Decompiled with CFR 0.152.
 */
package aist.daruma.client.darumaearth;

import aist.daruma.client.darumaearth.GmlGeometry;
import aist.daruma.client.darumaearth.GmlPoint;
import aist.daruma.client.darumaearth.ScanGmlException;
import aist.daruma.client.darumaearth.XmlUtil;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GmlCurve
extends GmlGeometry {
    protected static final String tagName = "Curve";
    protected ArrayList<GmlPoint> pointList = new ArrayList();

    @Override
    public String gmlTagName() {
        return tagName;
    }

    @Override
    public String gmlTagFullName() {
        return "gml:Curve";
    }

    public ArrayList<GmlPoint> getPointList() {
        return this.pointList;
    }

    public boolean addPoint(GmlPoint point) {
        return this.pointList.add(point);
    }

    public int getPointListSize() {
        return this.pointList.size();
    }

    public GmlPoint getPointAt(int index) {
        if (this.pointList.size() <= index) {
            return null;
        }
        return this.pointList.get(index);
    }

    public Iterator iterator() {
        return this.getPointList().iterator();
    }

    protected void scanGmlBodyAndAddPoints(Node xmlNode, NamespaceContext nsContext, Object crs) throws ScanGmlException, Exception {
        Node coordNode = XmlUtil.getNodeByXPath(xmlNode, "gml:coordinates/text()", nsContext);
        if (coordNode == null) {
            throw new ScanGmlException("gml:coordinates/text() not matched.");
        }
        String gmlCoordStr = coordNode.getNodeValue();
        String[] pointStrList = gmlCoordStr.split("[ \t\r\n]");
        for (int i = 0; i < pointStrList.length; ++i) {
            this.addPoint(GmlPoint.newPointForCoordinatesWithCRS(pointStrList[i], crs));
        }
    }

    public static GmlCurve scanGmlBody(Node xmlNode, NamespaceContext nsContext, Object crs) throws Exception {
        GmlCurve curve = new GmlCurve();
        curve.scanGmlBodyAndAddPoints(xmlNode, nsContext, crs);
        return curve;
    }
}

