/*
 * Decompiled with CFR 0.152.
 */
package aist.daruma.client.darumaearth;

import java.util.HashMap;
import java.util.Iterator;

public class GmlUtil {
    private static GmlUtil gmlUtil = new GmlUtil();
    public static final double gmlVersion = 2.0;
    private String tagName_exterior = "gml:outerBoundaryIs";
    private String tagName_interior = "gml:innerBoundaryIs";
    public static final String systemCRS = "#systemCRS";
    public static final String defaultCRS = "#systemCRS";
    public static final String systemTimeZone = "+09:00";
    public static final String defaultTimeZone = "+09:00";

    private GmlUtil() {
    }

    public static GmlUtil getInstance() {
        return gmlUtil;
    }

    public static String tagName_exterior() {
        return GmlUtil.gmlUtil.tagName_exterior;
    }

    public static String tagName_interior() {
        return GmlUtil.gmlUtil.tagName_interior;
    }

    public static String xmlTaggedBlock(String tagLabel, String propStr, String bodyStr, boolean indent) {
        StringBuilder strbuf = new StringBuilder();
        if (bodyStr == null || bodyStr.equals("")) {
            strbuf.append('<').append(tagLabel).append(propStr).append("/>");
        } else {
            strbuf.append('<').append(tagLabel).append(propStr).append(">");
            strbuf.append(bodyStr);
            strbuf.append("</").append(tagLabel).append('>');
        }
        return strbuf.toString();
    }

    public static String xmlTaggedBlock(String tagLabel, HashMap prop, String bodyStr, boolean indent) {
        String propStr = "";
        if (prop != null) {
            propStr = "";
            Iterator itSlot = prop.keySet().iterator();
            StringBuilder strbuf = new StringBuilder();
            while (itSlot.hasNext()) {
                String slot = itSlot.next().toString();
                strbuf.append(' ');
                strbuf.append(slot);
                strbuf.append('=');
                strbuf.append(prop.get(slot));
            }
            propStr = strbuf.toString();
        }
        return GmlUtil.xmlTaggedBlock(tagLabel, propStr, bodyStr, indent);
    }

    public static double[] gmlCoodStrToSysValueWithCRS(String posStr, Object CRS) {
        String[] strs = posStr.split(",");
        double x = Double.parseDouble(strs[0]);
        double y = Double.parseDouble(strs[1]);
        return GmlUtil.coodGmlToSys(x, y, CRS);
    }

    private static double[] coodGmlToSys(double x, double y, Object crs) {
        return GmlUtil.convertCRS(x, y, "#systemCRS", crs);
    }

    private static double[] coodSysToGml(double x, double y, Object crs) {
        return GmlUtil.convertCRS(x, y, crs, "#systemCRS");
    }

    private static double[] convertCRS(double x, double y, Object fromCRS, Object toCRS) {
        return new double[]{x, y};
    }
}

