/*
 * Decompiled with CFR 0.152.
 */
package aist.daruma.client.darumaearth;

import aist.daruma.client.darumaearth.DarumaEarthConfig;
import aist.daruma.client.darumaearth.DarumaEarthlNamespaceContext;
import aist.daruma.client.darumaearth.GmlGeometry;
import aist.daruma.client.darumaearth.GmlLineString;
import aist.daruma.client.darumaearth.GmlPoint;
import aist.daruma.client.darumaearth.GmlPolygon;
import aist.daruma.client.darumaearth.MispRequestBuilder;
import aist.daruma.client.darumaearth.MispSOAPClient;
import aist.daruma.client.darumaearth.ScanGmlException;
import aist.daruma.client.darumaearth.XmlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class KMLConverter
extends DefaultHandler {
    public static final String KMLROOT_NODE_STR = "<kml xmlns='http://earth.google.com/kml/2.1'>";
    private DarumaEarthConfig conf = DarumaEarthConfig.getConfig();
    private String featureName;
    private String locationXPath;
    private MispRequestBuilder mispReqBuilder;
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder builder;
    private Document doc;
    private Node lastSibling = null;
    private Stack<Node> nodeStack;
    private DarumaEarthlNamespaceContext nsContext;
    private DarumaEarthlNamespaceContext nsContextForSax;
    private boolean inFeatureTagFlag = false;
    private FileOutputStream outStream;
    private Node placemarkStyle = null;
    private String defaultNsUri;
    private HashMap<String, String> imageFileNameList;
    private HashMap<String, String> imageFileCacheList;
    private int featureCount = 0;

    private void pushNode(Node newNode) {
        this.nodeStack.push(newNode);
    }

    private Node popNode() {
        Node n = this.nodeStack.pop();
        return n;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inFeatureTagFlag) {
            if (length == 0) {
                return;
            }
            Node last = this.nodeStack.peek();
            if (last != this.doc) {
                String text = new String(ch, start, length);
                if (this.lastSibling != null && this.lastSibling.getNodeType() == 3) {
                    ((Text)this.lastSibling).appendData(text);
                } else {
                    this.lastSibling = last.appendChild(this.doc.createTextNode(text));
                }
            }
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.nsContextForSax.registerNamespace(prefix, uri);
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        String tagName = qName;
        String nsUri = namespaceURI;
        if (!this.inFeatureTagFlag && tagName.equals(this.featureName)) {
            this.inFeatureTagFlag = true;
            this.doc = this.builder.newDocument();
            this.defaultNsUri = nsUri;
            this.pushNode(this.doc);
        }
        if (this.inFeatureTagFlag) {
            Element elem = null;
            elem = (this.conf.prefixNs() == null || this.conf.prefixNs().equals("")) && nsUri.equals(this.defaultNsUri) ? this.doc.createElementNS("", tagName) : this.doc.createElementNS(nsUri, tagName);
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String ns = attrs.getURI(i);
                    String qn = attrs.getQName(i);
                    if (qn.startsWith("xmlns:") || qn.equals("xmlns")) {
                        ns = "http://www.w3.org/2000/xmlns/";
                    }
                    elem.setAttributeNS(ns, qn, attrs.getValue(i));
                }
                Node last = this.nodeStack.peek();
                last.appendChild(elem);
                this.pushNode(elem);
            }
        }
        this.lastSibling = null;
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (this.inFeatureTagFlag && qName.equals(this.featureName)) {
            this.inFeatureTagFlag = false;
            Node n = this.popNode();
            this.processToKML(n);
        }
        if (this.inFeatureTagFlag) {
            this.popNode();
        }
        this.lastSibling = null;
    }

    private Node genSimpleNode(String tagName, String value) {
        Element node = this.doc.createElement(tagName);
        node.appendChild(this.doc.createTextNode(value));
        return node;
    }

    private Node genSimpleNode(String tagName, double value) {
        return this.genSimpleNode(tagName, Double.toString(value));
    }

    private Node genSimpleNode(String tagName, int value) {
        return this.genSimpleNode(tagName, Integer.toString(value));
    }

    private Node genPlaceMarkStyle() {
        Element nodeStyle = this.doc.createElement("Style");
        Element nodeIconStyle = this.doc.createElement("IconStyle");
        nodeIconStyle.appendChild(this.genSimpleNode("color", this.conf.iconColor()));
        nodeIconStyle.appendChild(this.genSimpleNode("scale", this.conf.iconScale()));
        Element nodeIcon = this.doc.createElement("Icon");
        nodeIcon.appendChild(this.genSimpleNode("href", this.conf.iconHref()));
        nodeIcon.appendChild(this.genSimpleNode("x", this.conf.iconX()));
        nodeIcon.appendChild(this.genSimpleNode("y", this.conf.iconY()));
        nodeIcon.appendChild(this.genSimpleNode("w", this.conf.iconW()));
        nodeIcon.appendChild(this.genSimpleNode("h", this.conf.iconH()));
        nodeIconStyle.appendChild(nodeIcon);
        nodeStyle.appendChild(nodeIconStyle);
        Element nodeLabelStyle = this.doc.createElement("LabelStyle");
        nodeLabelStyle.appendChild(this.genSimpleNode("color", this.conf.labelColor()));
        nodeLabelStyle.appendChild(this.genSimpleNode("scale", this.conf.labelScale()));
        nodeStyle.appendChild(nodeLabelStyle);
        Element nodeLineStyle = this.doc.createElement("LineStyle");
        nodeLineStyle.appendChild(this.genSimpleNode("color", this.conf.lineColor()));
        nodeLineStyle.appendChild(this.genSimpleNode("width", this.conf.lineWidth()));
        nodeStyle.appendChild(nodeLineStyle);
        this.placemarkStyle = nodeStyle;
        return this.placemarkStyle;
    }

    private Node genPlaceMarkBody(String name, double x, double y, Node geoNode, Node descNode, String timeStamp, Node nodePlacemarkRoot) {
        Element nodePlacemark = this.doc.createElement("Placemark");
        nodePlacemark.appendChild(this.genSimpleNode("name", name));
        if (this.conf.timestamp() && timeStamp != null && !timeStamp.equals("")) {
            String kmlDateTime = timeStamp.replaceFirst("(:\\d{2})\\.\\d{3}", "$1");
            Element timestampNode = this.doc.createElement("TimeStamp");
            Element whenElem = this.doc.createElement("when");
            whenElem.setTextContent(kmlDateTime);
            timestampNode.appendChild(whenElem);
            nodePlacemark.appendChild(timestampNode);
        }
        if (descNode != null) {
            nodePlacemark.appendChild(descNode);
        }
        Element nodeLookAt = this.doc.createElement("LookAt");
        nodeLookAt.appendChild(this.genSimpleNode("longitude", x));
        nodeLookAt.appendChild(this.genSimpleNode("latitude", y));
        nodePlacemark.appendChild(nodeLookAt);
        nodePlacemark.appendChild(this.genPlaceMarkStyle());
        nodePlacemark.appendChild(geoNode);
        nodePlacemarkRoot.appendChild(nodePlacemark);
        return nodePlacemark;
    }

    private Node genDescTableRow(String label, String value) {
        Element row = this.doc.createElement("TR");
        Element labelNode = this.doc.createElement("TD");
        labelNode.setTextContent(label);
        Element valueNode = this.doc.createElement("TD");
        valueNode.setTextContent(value);
        row.appendChild(labelNode);
        row.appendChild(valueNode);
        return row;
    }

    private void getDescTableBody(Node featureNode, String xpath, Node descTableNode) {
        NamedNodeMap attrMapList = featureNode.getAttributes();
        if (attrMapList != null) {
            for (int i = 0; i < attrMapList.getLength(); ++i) {
                Node attr = attrMapList.item(i);
                String attrName = attr.getNodeName();
                if (attrName.equals("xmlns") || attrName.startsWith("xmlns:")) continue;
                String attrXPath = xpath + "@" + attrName;
                String attrValue = attr.getNodeValue();
                Node node = this.genDescTableRow(attrXPath, attrValue);
                descTableNode.appendChild(node);
            }
        }
        Node elem = XmlUtil.getFirstChildElement(featureNode);
        while (elem != null) {
            String childXPath = xpath + elem.getLocalName() + "/";
            this.getDescTableBody(elem, childXPath, descTableNode);
            elem = XmlUtil.getNextSiblingElement(elem);
        }
        if (XmlUtil.getFirstChildElement(featureNode) == null) {
            String value = featureNode.getTextContent();
            value.replaceFirst("/^[ \t\n\r]+/", "");
            value.replaceFirst("/[ \t\n\r]+$/", "");
            if (value != null && !value.equals("")) {
                if (value.length() > this.conf.valueMaxLen()) {
                    value = value.substring(0, this.conf.valueMaxLen()) + " ...";
                }
                Node node = this.genDescTableRow(xpath, value);
                descTableNode.appendChild(node);
            }
        }
    }

    private Node transformDescTree(Node featureNode, String name, String imageFeature) {
        Element descNode = this.doc.createElement("description");
        Element descTableNode = this.doc.createElement("TABLE");
        this.getDescTableBody(featureNode, "./", descTableNode);
        StringWriter sw = new StringWriter();
        sw.write(name);
        XmlUtil.domToWriter(descTableNode, sw);
        CDATASection descCDATA = this.doc.createCDATASection(sw.toString());
        descNode.appendChild(descCDATA);
        for (String imageId : this.imageFileNameList.keySet()) {
            try {
                Node n = this.getImageData(imageId, imageFeature);
                if (n == null) continue;
                descNode.appendChild(n);
            }
            catch (Exception ex) {
                if (!this.conf.debug()) continue;
                ex.printStackTrace();
            }
        }
        return descNode;
    }

    private String getTimestamp(Node featureNode) throws Exception {
        String timestampXPath = this.conf.timestampXPath();
        Node timestampNode = XmlUtil.getNodeByXPath(featureNode, timestampXPath, this.nsContext);
        if (timestampNode != null) {
            return timestampNode.getNodeValue();
        }
        return null;
    }

    private Node getPositionNode(Node featureNode) throws Exception {
        String posXPath = this.locationXPath;
        featureNode.getPrefix();
        Node posNode = XmlUtil.getNodeByXPath(featureNode, posXPath, this.nsContext);
        return posNode;
    }

    private double[] convertToLatLon(double x, double y) {
        double[] result = new double[2];
        if (this.conf.flipXY()) {
            double t = x;
            x = y;
            y = t;
        }
        double offsetX = this.conf.offsetX();
        double offsetY = this.conf.offsetY();
        double scaleX = this.conf.scaleX();
        double scaleY = this.conf.scaleY();
        result[0] = offsetX + scaleX * x;
        result[1] = offsetY + scaleY * y;
        return result;
    }

    private void genPlacemarkPointBody(String name, GmlPoint gmlPoint, Node descNode, String timeStamp, Node placemarkRootNode) {
        StringBuilder sb = new StringBuilder();
        String altModeStr = "relativeToGround";
        double x = gmlPoint.getX();
        double y = gmlPoint.getY();
        double[] latlon = this.convertToLatLon(x, y);
        double lat = latlon[0];
        double lon = latlon[1];
        sb.append(lat).append(',').append(lon);
        if (gmlPoint.hasZ()) {
            sb.append(',').append(gmlPoint.getZ());
            altModeStr = "absolute";
        }
        String coordStr = sb.toString();
        Element pointNode = this.doc.createElement("Point");
        Element altNode = this.doc.createElement("altitudeMode");
        altNode.appendChild(this.doc.createTextNode(altModeStr));
        Element coordNode = this.doc.createElement("coordinates");
        coordNode.appendChild(this.doc.createTextNode(coordStr));
        pointNode.appendChild(altNode);
        pointNode.appendChild(coordNode);
        this.genPlaceMarkBody(name, lat, lon, pointNode, descNode, timeStamp, placemarkRootNode);
    }

    private void genPlacemarkLineBody(String name, GmlLineString gmlLineString, Node descNode, String timeStamp, Node placemarkRootNode) {
        GmlPoint point0 = gmlLineString.getPointAt(0);
        this.genPlacemarkPointBody(name, point0, descNode, timeStamp, placemarkRootNode);
        double[] latlon0 = this.convertToLatLon(point0.getX(), point0.getY());
        double lat0 = latlon0[0];
        double lon0 = latlon0[1];
        Element lsNode = this.doc.createElement("LineString");
        Element altNode = this.doc.createElement("altitudeMode");
        String altMode = "relativeToGround";
        if (point0.hasZ()) {
            altMode = "absolute";
        }
        altNode.appendChild(this.doc.createTextNode(altMode));
        Element coordNode = this.doc.createElement("coordinates");
        StringBuilder sb = new StringBuilder();
        Iterator i = gmlLineString.iterator();
        boolean first = true;
        while (i.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            GmlPoint point = (GmlPoint)i.next();
            double[] latlon = this.convertToLatLon(point.getX(), point.getY());
            double lat = latlon[0];
            double lon = latlon[1];
            sb.append(lat).append(',').append(lon);
            if (point.hasZ()) {
                sb.append(',').append(point.getZ());
                continue;
            }
            sb.append(',').append(this.conf.offsetZ());
        }
        String coordStr = sb.toString();
        coordNode.appendChild(this.doc.createTextNode(coordStr));
        lsNode.appendChild(altNode);
        lsNode.appendChild(coordNode);
        this.genPlaceMarkBody(name, lat0, lon0, lsNode, null, timeStamp, placemarkRootNode);
    }

    private void genPlacemarkPolygonBody(String name, GmlPolygon gmlPolygon, Node descNode, String timeStamp, Node placemarkRootNode) {
        GmlPoint point0 = gmlPolygon.getExterior().getPointAt(0);
        this.genPlacemarkPointBody(name, point0, descNode, timeStamp, placemarkRootNode);
        double[] latlon0 = this.convertToLatLon(point0.getX(), point0.getY());
        double lat0 = latlon0[0];
        double lon0 = latlon0[1];
        Element polyNode = this.doc.createElement("Polygon");
        Element altNode = this.doc.createElement("altitudeMode");
        String altMode = "relativeToGround";
        if (point0.hasZ()) {
            altMode = "absolute";
        }
        altNode.appendChild(this.doc.createTextNode(altMode));
        Node altNode2 = altNode.cloneNode(true);
        polyNode.appendChild(altNode);
        Element lrNode = this.doc.createElement("LinearRing");
        Element coordNode = this.doc.createElement("coordinates");
        StringBuilder sb = new StringBuilder();
        Iterator i = gmlPolygon.getExterior().iterator();
        while (i.hasNext()) {
            GmlPoint point = (GmlPoint)i.next();
            double[] latlon = this.convertToLatLon(point.getX(), point.getY());
            double lat = latlon[0];
            double lon = latlon[1];
            sb.append(lat).append(',').append(lon);
            if (point.hasZ()) {
                sb.append(',').append(point.getZ());
            } else {
                sb.append(',').append(this.conf.offsetZ());
            }
            sb.append(' ');
        }
        String coordStr = sb.toString();
        lrNode.appendChild(coordNode);
        coordNode.appendChild(this.doc.createTextNode(coordStr));
        Element outerBoundaryNode = this.doc.createElement("outerBoundaryIs");
        outerBoundaryNode.appendChild(altNode2);
        outerBoundaryNode.appendChild(lrNode);
        polyNode.appendChild(outerBoundaryNode);
        this.genPlaceMarkBody(name, lat0, lon0, polyNode, null, timeStamp, placemarkRootNode);
    }

    private Node transformGeoNodes(String name, Node posNode, Node descNode, String timeStamp) throws Exception {
        DocumentFragment placeMarks;
        block8: {
            Node geoNode = XmlUtil.getFirstChildElement(posNode);
            if (geoNode == null) {
                return null;
            }
            placeMarks = this.doc.createDocumentFragment();
            try {
                GmlGeometry gmlGeom = GmlGeometry.scanGml(geoNode, this.nsContextForSax, null);
                if (gmlGeom.gmlTagName().equals("Point")) {
                    GmlPoint gmlPoint = (GmlPoint)gmlGeom;
                    this.genPlacemarkPointBody(name, gmlPoint, descNode, timeStamp, placeMarks);
                } else if (gmlGeom.gmlTagName().equals("LineString")) {
                    GmlLineString gmlLineString = (GmlLineString)gmlGeom;
                    this.genPlacemarkLineBody(name, gmlLineString, descNode, timeStamp, placeMarks);
                } else if (gmlGeom.gmlTagName().equals("Polygon")) {
                    GmlPolygon gmlPolygon = (GmlPolygon)gmlGeom;
                    this.genPlacemarkPolygonBody(name, gmlPolygon, descNode, timeStamp, placeMarks);
                }
            }
            catch (ScanGmlException sge) {
                if (!this.conf.debug()) break block8;
                System.out.println(sge.getMessage());
            }
        }
        return placeMarks;
    }

    private String genImageFileName(String imageId) {
        StringBuffer sb = new StringBuffer();
        File imageIdFile = new File(imageId);
        String imageDir = this.conf.imageDir();
        sb.append(imageDir);
        if (!imageDir.endsWith(File.separator)) {
            sb.append(File.separator);
        }
        String basename = imageIdFile.getName();
        sb.append(basename);
        return sb.toString();
    }

    private void scanImageNode(Node node) throws Exception {
        String imageRefXPath = this.conf.dataRefXPath();
        String imageId = XmlUtil.getNodeValueByXPath(node, imageRefXPath, this.nsContext);
        if (imageId != null) {
            String imageFileName = this.genImageFileName(imageId);
            this.imageFileNameList.put(imageId, imageFileName);
        }
    }

    private Node getImageData(String imageId, String featureName) throws Exception {
        String imageIdXPath = this.conf.dataIdXPath();
        String imageDataXPath = this.conf.dataXPath();
        String encodeXPath = this.conf.encodeXPath();
        Element resultImageNode = null;
        if (this.imageFileCacheList.containsKey(imageId)) {
            return null;
        }
        String imageFileName = this.imageFileNameList.get(imageId);
        Node requestNode = this.mispReqBuilder.genGetFeatureGetImageData(featureName, imageId, imageIdXPath, this.conf.prefixNs(), this.conf.prefixUri());
        String reqFileName = "";
        String resFileName = "";
        Node imageDataNode = null;
        try {
            File workDir = new File(this.conf.workDir());
            File reqFile = File.createTempFile("imgreq", ".xml", workDir);
            reqFile.deleteOnExit();
            reqFileName = reqFile.getCanonicalPath();
            File resFile = File.createTempFile("imgres", ".xml", workDir);
            resFile.deleteOnExit();
            resFileName = resFile.getCanonicalPath();
            this.mispReqBuilder.requestToFile(reqFileName, requestNode);
            MispSOAPClient client = new MispSOAPClient();
            FileInputStream request = new FileInputStream(reqFileName);
            FileOutputStream response = new FileOutputStream(resFileName);
            client.sendRequest(this.conf.darumaHost(), this.conf.darumaPort(), request, response);
            response.close();
            Node responseTree = XmlUtil.fileToDom(resFile, this.builder);
            imageDataNode = XmlUtil.getNodeByXPath(responseTree, "//gml:featureMember/*", this.nsContext);
        }
        catch (FileNotFoundException nfe) {
            nfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (imageDataNode != null) {
            Node dataNode = XmlUtil.getNodeByXPath(imageDataNode, imageDataXPath, this.nsContext);
            if (dataNode == null) {
                throw new Exception("data Node not found.");
            }
            Node encodingNode = XmlUtil.getNodeByXPath(imageDataNode, encodeXPath, this.nsContext);
            String encoding = "base64";
            if (encodingNode != null) {
                encoding = encodingNode.getTextContent();
            }
            if (encoding.equals("base64")) {
                String base64Data = dataNode.getTextContent();
                byte[] imageBinary = Base64.decodeBase64((byte[])base64Data.getBytes());
                try {
                    String realImageFileName = this.conf.kmlOutputDir() + "/" + imageFileName;
                    FileOutputStream imgFileStream = new FileOutputStream(realImageFileName);
                    imgFileStream.write(imageBinary);
                    imgFileStream.close();
                }
                catch (FileNotFoundException fne) {
                    fne.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                Element elem = this.doc.createElement("img");
                elem.setAttribute("src", imageFileName);
                resultImageNode = elem;
            } else if (encoding.equals("xlink:href")) {
                Element elem = this.doc.createElement("a");
                String rawdata = dataNode.getTextContent();
                elem.setAttribute("href", rawdata);
                Text clickHereNode = this.doc.createTextNode("Click Here");
                elem.appendChild(clickHereNode);
                resultImageNode = elem;
            }
        }
        this.imageFileCacheList.put(imageId, imageFileName);
        return resultImageNode;
    }

    private void processToKML(Node featureNode) {
        block6: {
            ++this.featureCount;
            if (this.featureCount > 10) {
                this.featureCount = 0;
                if (this.conf.debug()) {
                    System.out.print(".");
                }
            }
            try {
                Node posNode = this.getPositionNode(featureNode);
                if (posNode == null) {
                    return;
                }
                String imageDataFeature = this.conf.dataFeature();
                if (imageDataFeature != null && !imageDataFeature.equals("") && !imageDataFeature.equals("-")) {
                    this.scanImageNode(featureNode);
                }
                String timeStamp = this.getTimestamp(featureNode);
                String name = this.conf.defaultName();
                Node descNode = this.transformDescTree(featureNode, name, imageDataFeature);
                Node placeMarks = this.transformGeoNodes(name, posNode, descNode, timeStamp);
                XmlUtil.domToStream(placeMarks, this.outStream);
            }
            catch (Exception ex) {
                if (!this.conf.debug()) break block6;
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(String featureName, String locXPath, FileInputStream src, FileOutputStream dst) throws IOException {
        this.outStream = dst;
        this.featureName = featureName;
        this.locationXPath = locXPath;
        this.nodeStack = new Stack();
        String prefixNs = this.conf.prefixNs();
        String prefixUri = this.conf.prefixUri();
        if (prefixUri != null && !prefixUri.equals("")) {
            if (prefixNs == null) {
                this.nsContext.registerNamespace("", prefixUri);
            } else if (prefixUri != null && !prefixUri.equals("")) {
                this.nsContext.registerNamespace(prefixNs, this.conf.prefixUri());
            }
        }
        this.imageFileNameList.clear();
        this.imageFileCacheList.clear();
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)dst, "UTF8");
            out.write(KMLROOT_NODE_STR);
            out.write("<Document><Folder>\n");
            out.write("<name>" + featureName + "</name>\n");
            out.flush();
        }
        catch (UnsupportedEncodingException usex) {
            System.out.print("Internal error for output kml file...");
            System.out.println(usex.getMessage());
        }
        catch (IOException ioe) {
            System.out.print("Error for write kml file...");
            System.out.println(ioe.getMessage());
            throw ioe;
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            XMLReader reader = saxParser.getXMLReader();
            String id = "http://xml.org/sax/features/namespaces";
            reader.setFeature(id, true);
            saxParser.parse((InputStream)src, (DefaultHandler)this);
        }
        catch (Exception e) {
            System.out.print("Error on parsing response from DaRuMa server...");
            System.out.println(e.getMessage());
        }
        finally {
            try {
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)dst, "UTF8");
                out.write("</Folder></Document></kml>");
                out.flush();
            }
            catch (UnsupportedEncodingException usex) {
                System.out.print("Internal Error for output kml file...");
                System.out.println(usex.getMessage());
            }
            catch (IOException ioe) {
                System.out.print("Error on closing kml file...");
                System.out.println(ioe.getMessage());
                throw ioe;
            }
        }
    }

    public KMLConverter(MispRequestBuilder reqBuilder) throws ParserConfigurationException {
        this.factory.setNamespaceAware(true);
        this.nsContextForSax = new DarumaEarthlNamespaceContext();
        this.nsContext = new DarumaEarthlNamespaceContext();
        this.imageFileNameList = new HashMap();
        this.imageFileCacheList = new HashMap();
        this.mispReqBuilder = reqBuilder;
        try {
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            System.out.print("Internal error. can't get document builder...");
            System.out.println(pce.getMessage());
            throw pce;
        }
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Usage: KMLconverter conv <featureName> <locXpath> <srcfilename> <dstfilename>");
            System.exit(-1);
        }
        try {
            KMLConverter kmlconv = new KMLConverter(new MispRequestBuilder());
            System.out.println("get " + args[1] + "/ \"" + args[2] + "\" from " + args[3] + " to " + args[4]);
            String featureName = args[0];
            String locXPath = args[1];
            FileInputStream src = new FileInputStream(args[2]);
            FileOutputStream dst = new FileOutputStream(args[3]);
            kmlconv.convert(featureName, locXPath, src, dst);
            System.out.println("Done.");
        }
        catch (Exception e) {
            System.out.println("Exception occured " + e.getMessage());
            e.printStackTrace();
        }
    }
}

