/*
 * Decompiled with CFR 0.152.
 */
package aist.daruma.client.darumaearth;

import aist.daruma.client.darumaearth.DarumaEarthConfig;
import aist.daruma.client.darumaearth.XmlUtil;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MispRequestBuilder {
    private DarumaEarthConfig conf = DarumaEarthConfig.getConfig();
    private Document doc;

    public MispRequestBuilder() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            System.out.print("Internal error. can't get document builder...");
            System.out.println(pce.getMessage());
            throw pce;
        }
    }

    public Node wrapBySoapEnv(Node node) {
        Element soapenv = null;
        String soapNsURI = XmlUtil.getNameSpaceURL("soap");
        Element root = this.doc.createElementNS(soapNsURI, "SOAP-ENV:Envelope");
        root.appendChild(node);
        soapenv = root;
        return soapenv;
    }

    private Element setNameSpaceList(Element el, String[] nameSpaceList) {
        if (nameSpaceList == null) {
            return el;
        }
        for (int i = 0; i < nameSpaceList.length; ++i) {
            String s = nameSpaceList[i];
            el.setAttribute("xmlns:" + s, XmlUtil.getNameSpaceURL(s));
        }
        return el;
    }

    private Element setNameSpace(Element el, String prefix, String uri) {
        String ns = "xmlns";
        if (prefix != null && !prefix.equals("")) {
            ns = ns + ":" + prefix;
        }
        if (uri != null && uri != "") {
            el.setAttribute(ns, uri);
        }
        return el;
    }

    public Node genGetFeature(String featureName, Node condNode, String prefixNs, String prefixUri) {
        Element featureNode = null;
        featureNode = this.doc.createElement("misp:GetFeature");
        featureNode = this.setNameSpaceList(featureNode, new String[]{"gml", "xlink", "misp"});
        featureNode = this.setNameSpace(featureNode, prefixNs, prefixUri);
        Element queryElement = this.doc.createElement("misp:Query");
        queryElement.setAttribute("mode", "features");
        queryElement.setAttribute("typeName", featureName);
        featureNode.appendChild(queryElement);
        Element filterElement = this.doc.createElement("misp:Filter");
        queryElement.appendChild(filterElement);
        if (condNode == null) {
            Element cond = this.doc.createElement("misp:True");
            filterElement.appendChild(cond);
        } else {
            filterElement.appendChild(condNode);
        }
        return featureNode;
    }

    public void requestToFile(String filename, Node requestNode) throws FileNotFoundException {
        Node soap = this.wrapBySoapEnv(requestNode);
        FileOutputStream reqFileStream = new FileOutputStream(filename);
        XmlUtil.domToStream(soap, reqFileStream);
    }

    public void genGetFeatureRequestToFile(String filename, String featureName, String prefixNs, String prefixUri) throws FileNotFoundException {
        Node requestNode = this.genGetFeature(featureName, null, prefixNs, prefixUri);
        this.requestToFile(filename, requestNode);
    }

    public Node genGetFeatureGetImageData(String featureName, String imageId, String idPath, String prefixNs, String prefixUri) {
        Element propNode = this.doc.createElement("misp:PropertyName");
        propNode.setTextContent(idPath);
        Element litNode = this.doc.createElement("misp:Literal");
        litNode.setTextContent(imageId);
        Element condNode = this.doc.createElement("misp:PropertyIsEqualTo");
        condNode.appendChild(propNode);
        condNode.appendChild(litNode);
        return this.genGetFeature(featureName, condNode, prefixNs, prefixUri);
    }

    public static void main(String[] args) {
        try {
            MispRequestBuilder builder = new MispRequestBuilder();
            Node requestNode = builder.genGetFeature("AlertInformation", null, null, null);
            Node soap = builder.wrapBySoapEnv(requestNode);
            XmlUtil.domToStream(soap, System.out);
            Node requestImageNode = builder.genGetFeatureGetImageData("sensedDataEntity", "http://someware/some.img", "./@gml:id", null, null);
            Node imageSoap = builder.wrapBySoapEnv(requestImageNode);
            XmlUtil.domToStream(imageSoap, System.out);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

